/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.ComputeCapacityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the capacity for a fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ComputeCapacity implements StructuredPojo, ToCopyableBuilder<ComputeCapacity.Builder, ComputeCapacity> {
    private final Integer desiredInstances;

    private ComputeCapacity(BuilderImpl builder) {
        this.desiredInstances = builder.desiredInstances;
    }

    /**
     * <p>
     * The desired number of streaming instances.
     * </p>
     * 
     * @return The desired number of streaming instances.
     */
    public Integer desiredInstances() {
        return desiredInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(desiredInstances());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeCapacity)) {
            return false;
        }
        ComputeCapacity other = (ComputeCapacity) obj;
        return Objects.equals(desiredInstances(), other.desiredInstances());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (desiredInstances() != null) {
            sb.append("DesiredInstances: ").append(desiredInstances()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DesiredInstances":
            return Optional.of(clazz.cast(desiredInstances()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComputeCapacityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ComputeCapacity> {
        /**
         * <p>
         * The desired number of streaming instances.
         * </p>
         * 
         * @param desiredInstances
         *        The desired number of streaming instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredInstances(Integer desiredInstances);
    }

    static final class BuilderImpl implements Builder {
        private Integer desiredInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeCapacity model) {
            desiredInstances(model.desiredInstances);
        }

        public final Integer getDesiredInstances() {
            return desiredInstances;
        }

        @Override
        public final Builder desiredInstances(Integer desiredInstances) {
            this.desiredInstances = desiredInstances;
            return this;
        }

        public final void setDesiredInstances(Integer desiredInstances) {
            this.desiredInstances = desiredInstances;
        }

        @Override
        public ComputeCapacity build() {
            return new ComputeCapacity(this);
        }
    }
}
