/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus;
import software.amazon.awssdk.services.appstream.model.FleetError;
import software.amazon.awssdk.services.appstream.model.FleetErrorsCopier;
import software.amazon.awssdk.services.appstream.model.FleetState;
import software.amazon.awssdk.services.appstream.model.VpcConfig;
import software.amazon.awssdk.services.appstream.transform.FleetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Fleet
implements StructuredPojo,
ToCopyableBuilder<Builder, Fleet> {
    private final String arn;
    private final String name;
    private final String displayName;
    private final String description;
    private final String imageName;
    private final String instanceType;
    private final ComputeCapacityStatus computeCapacityStatus;
    private final Integer maxUserDurationInSeconds;
    private final Integer disconnectTimeoutInSeconds;
    private final String state;
    private final VpcConfig vpcConfig;
    private final Instant createdTime;
    private final List<FleetError> fleetErrors;
    private final Boolean enableDefaultInternetAccess;

    private Fleet(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.imageName = builder.imageName;
        this.instanceType = builder.instanceType;
        this.computeCapacityStatus = builder.computeCapacityStatus;
        this.maxUserDurationInSeconds = builder.maxUserDurationInSeconds;
        this.disconnectTimeoutInSeconds = builder.disconnectTimeoutInSeconds;
        this.state = builder.state;
        this.vpcConfig = builder.vpcConfig;
        this.createdTime = builder.createdTime;
        this.fleetErrors = builder.fleetErrors;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String displayName() {
        return this.displayName;
    }

    public String description() {
        return this.description;
    }

    public String imageName() {
        return this.imageName;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public ComputeCapacityStatus computeCapacityStatus() {
        return this.computeCapacityStatus;
    }

    public Integer maxUserDurationInSeconds() {
        return this.maxUserDurationInSeconds;
    }

    public Integer disconnectTimeoutInSeconds() {
        return this.disconnectTimeoutInSeconds;
    }

    public FleetState state() {
        return FleetState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public List<FleetError> fleetErrors() {
        return this.fleetErrors;
    }

    public Boolean enableDefaultInternetAccess() {
        return this.enableDefaultInternetAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.displayName() == null ? 0 : this.displayName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.imageName() == null ? 0 : this.imageName().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.computeCapacityStatus() == null ? 0 : this.computeCapacityStatus().hashCode());
        hashCode = 31 * hashCode + (this.maxUserDurationInSeconds() == null ? 0 : this.maxUserDurationInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.disconnectTimeoutInSeconds() == null ? 0 : this.disconnectTimeoutInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.stateString() == null ? 0 : this.stateString().hashCode());
        hashCode = 31 * hashCode + (this.vpcConfig() == null ? 0 : this.vpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.createdTime() == null ? 0 : this.createdTime().hashCode());
        hashCode = 31 * hashCode + (this.fleetErrors() == null ? 0 : this.fleetErrors().hashCode());
        hashCode = 31 * hashCode + (this.enableDefaultInternetAccess() == null ? 0 : this.enableDefaultInternetAccess().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fleet)) {
            return false;
        }
        Fleet other = (Fleet)obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.imageName() == null ^ this.imageName() == null) {
            return false;
        }
        if (other.imageName() != null && !other.imageName().equals(this.imageName())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.computeCapacityStatus() == null ^ this.computeCapacityStatus() == null) {
            return false;
        }
        if (other.computeCapacityStatus() != null && !other.computeCapacityStatus().equals(this.computeCapacityStatus())) {
            return false;
        }
        if (other.maxUserDurationInSeconds() == null ^ this.maxUserDurationInSeconds() == null) {
            return false;
        }
        if (other.maxUserDurationInSeconds() != null && !other.maxUserDurationInSeconds().equals(this.maxUserDurationInSeconds())) {
            return false;
        }
        if (other.disconnectTimeoutInSeconds() == null ^ this.disconnectTimeoutInSeconds() == null) {
            return false;
        }
        if (other.disconnectTimeoutInSeconds() != null && !other.disconnectTimeoutInSeconds().equals(this.disconnectTimeoutInSeconds())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.vpcConfig() == null ^ this.vpcConfig() == null) {
            return false;
        }
        if (other.vpcConfig() != null && !other.vpcConfig().equals(this.vpcConfig())) {
            return false;
        }
        if (other.createdTime() == null ^ this.createdTime() == null) {
            return false;
        }
        if (other.createdTime() != null && !other.createdTime().equals(this.createdTime())) {
            return false;
        }
        if (other.fleetErrors() == null ^ this.fleetErrors() == null) {
            return false;
        }
        if (other.fleetErrors() != null && !other.fleetErrors().equals(this.fleetErrors())) {
            return false;
        }
        if (other.enableDefaultInternetAccess() == null ^ this.enableDefaultInternetAccess() == null) {
            return false;
        }
        return other.enableDefaultInternetAccess() == null || other.enableDefaultInternetAccess().equals(this.enableDefaultInternetAccess());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.imageName() != null) {
            sb.append("ImageName: ").append(this.imageName()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.computeCapacityStatus() != null) {
            sb.append("ComputeCapacityStatus: ").append(this.computeCapacityStatus()).append(",");
        }
        if (this.maxUserDurationInSeconds() != null) {
            sb.append("MaxUserDurationInSeconds: ").append(this.maxUserDurationInSeconds()).append(",");
        }
        if (this.disconnectTimeoutInSeconds() != null) {
            sb.append("DisconnectTimeoutInSeconds: ").append(this.disconnectTimeoutInSeconds()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.vpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.vpcConfig()).append(",");
        }
        if (this.createdTime() != null) {
            sb.append("CreatedTime: ").append(this.createdTime()).append(",");
        }
        if (this.fleetErrors() != null) {
            sb.append("FleetErrors: ").append(this.fleetErrors()).append(",");
        }
        if (this.enableDefaultInternetAccess() != null) {
            sb.append("EnableDefaultInternetAccess: ").append(this.enableDefaultInternetAccess()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "DisplayName": {
                return Optional.of(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "ImageName": {
                return Optional.of(clazz.cast(this.imageName()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "ComputeCapacityStatus": {
                return Optional.of(clazz.cast(this.computeCapacityStatus()));
            }
            case "MaxUserDurationInSeconds": {
                return Optional.of(clazz.cast(this.maxUserDurationInSeconds()));
            }
            case "DisconnectTimeoutInSeconds": {
                return Optional.of(clazz.cast(this.disconnectTimeoutInSeconds()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "VpcConfig": {
                return Optional.of(clazz.cast(this.vpcConfig()));
            }
            case "CreatedTime": {
                return Optional.of(clazz.cast(this.createdTime()));
            }
            case "FleetErrors": {
                return Optional.of(clazz.cast(this.fleetErrors()));
            }
            case "EnableDefaultInternetAccess": {
                return Optional.of(clazz.cast(this.enableDefaultInternetAccess()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FleetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String displayName;
        private String description;
        private String imageName;
        private String instanceType;
        private ComputeCapacityStatus computeCapacityStatus;
        private Integer maxUserDurationInSeconds;
        private Integer disconnectTimeoutInSeconds;
        private String state;
        private VpcConfig vpcConfig;
        private Instant createdTime;
        private List<FleetError> fleetErrors;
        private Boolean enableDefaultInternetAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(Fleet model) {
            this.arn(model.arn);
            this.name(model.name);
            this.displayName(model.displayName);
            this.description(model.description);
            this.imageName(model.imageName);
            this.instanceType(model.instanceType);
            this.computeCapacityStatus(model.computeCapacityStatus);
            this.maxUserDurationInSeconds(model.maxUserDurationInSeconds);
            this.disconnectTimeoutInSeconds(model.disconnectTimeoutInSeconds);
            this.state(model.state);
            this.vpcConfig(model.vpcConfig);
            this.createdTime(model.createdTime);
            this.fleetErrors(model.fleetErrors);
            this.enableDefaultInternetAccess(model.enableDefaultInternetAccess);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getImageName() {
            return this.imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final ComputeCapacityStatus.Builder getComputeCapacityStatus() {
            return this.computeCapacityStatus != null ? this.computeCapacityStatus.toBuilder() : null;
        }

        @Override
        public final Builder computeCapacityStatus(ComputeCapacityStatus computeCapacityStatus) {
            this.computeCapacityStatus = computeCapacityStatus;
            return this;
        }

        public final void setComputeCapacityStatus(ComputeCapacityStatus.BuilderImpl computeCapacityStatus) {
            this.computeCapacityStatus = computeCapacityStatus != null ? computeCapacityStatus.build() : null;
        }

        public final Integer getMaxUserDurationInSeconds() {
            return this.maxUserDurationInSeconds;
        }

        @Override
        public final Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
            return this;
        }

        public final void setMaxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
        }

        public final Integer getDisconnectTimeoutInSeconds() {
            return this.disconnectTimeoutInSeconds;
        }

        @Override
        public final Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
            return this;
        }

        public final void setDisconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(FleetState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Collection<FleetError.Builder> getFleetErrors() {
            return this.fleetErrors != null ? (Collection)this.fleetErrors.stream().map(FleetError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fleetErrors(Collection<FleetError> fleetErrors) {
            this.fleetErrors = FleetErrorsCopier.copy(fleetErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetErrors(FleetError ... fleetErrors) {
            this.fleetErrors(Arrays.asList(fleetErrors));
            return this;
        }

        public final void setFleetErrors(Collection<FleetError.BuilderImpl> fleetErrors) {
            this.fleetErrors = FleetErrorsCopier.copyFromBuilder(fleetErrors);
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return this.enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        public Fleet build() {
            return new Fleet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Fleet> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder imageName(String var1);

        public Builder instanceType(String var1);

        public Builder computeCapacityStatus(ComputeCapacityStatus var1);

        public Builder maxUserDurationInSeconds(Integer var1);

        public Builder disconnectTimeoutInSeconds(Integer var1);

        public Builder state(String var1);

        public Builder state(FleetState var1);

        public Builder vpcConfig(VpcConfig var1);

        public Builder createdTime(Instant var1);

        public Builder fleetErrors(Collection<FleetError> var1);

        public Builder fleetErrors(FleetError ... var1);

        public Builder enableDefaultInternetAccess(Boolean var1);
    }
}

