/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateStackResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<UpdateStackResponse.Builder, UpdateStackResponse> {
    private final Stack stack;

    private UpdateStackResponse(BuilderImpl builder) {
        this.stack = builder.stack;
    }

    /**
     * <p>
     * A list of stack details.
     * </p>
     * 
     * @return A list of stack details.
     */
    public Stack stack() {
        return stack;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stack() == null) ? 0 : stack().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackResponse)) {
            return false;
        }
        UpdateStackResponse other = (UpdateStackResponse) obj;
        if (other.stack() == null ^ this.stack() == null) {
            return false;
        }
        if (other.stack() != null && !other.stack().equals(this.stack())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stack() != null) {
            sb.append("Stack: ").append(stack()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Stack":
            return Optional.of(clazz.cast(stack()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateStackResponse> {
        /**
         * <p>
         * A list of stack details.
         * </p>
         * 
         * @param stack
         *        A list of stack details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stack(Stack stack);
    }

    static final class BuilderImpl implements Builder {
        private Stack stack;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackResponse model) {
            stack(model.stack);
        }

        public final Stack.Builder getStack() {
            return stack != null ? stack.toBuilder() : null;
        }

        @Override
        public final Builder stack(Stack stack) {
            this.stack = stack;
            return this;
        }

        public final void setStack(Stack.BuilderImpl stack) {
            this.stack = stack != null ? stack.build() : null;
        }

        @Override
        public UpdateStackResponse build() {
            return new UpdateStackResponse(this);
        }
    }
}
