/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateStreamingURLRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateStreamingURLRequest.Builder, CreateStreamingURLRequest> {
    private final String stackName;

    private final String fleetName;

    private final String userId;

    private final String applicationId;

    private final Long validity;

    private final String sessionContext;

    private CreateStreamingURLRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.fleetName = builder.fleetName;
        this.userId = builder.userId;
        this.applicationId = builder.applicationId;
        this.validity = builder.validity;
        this.sessionContext = builder.sessionContext;
    }

    /**
     * <p>
     * The stack for which the URL is generated.
     * </p>
     * 
     * @return The stack for which the URL is generated.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The fleet for which the URL is generated.
     * </p>
     * 
     * @return The fleet for which the URL is generated.
     */
    public String fleetName() {
        return fleetName;
    }

    /**
     * <p>
     * A unique user ID for whom the URL is generated.
     * </p>
     * 
     * @return A unique user ID for whom the URL is generated.
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * The ID of the application that must be launched after the session starts.
     * </p>
     * 
     * @return The ID of the application that must be launched after the session starts.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The duration up to which the URL returned by this action is valid. The input can be any numeric value in seconds
     * between 1 and 604800 seconds.
     * </p>
     * 
     * @return The duration up to which the URL returned by this action is valid. The input can be any numeric value in
     *         seconds between 1 and 604800 seconds.
     */
    public Long validity() {
        return validity;
    }

    /**
     * <p>
     * The sessionContext of the streaming URL.
     * </p>
     * 
     * @return The sessionContext of the streaming URL.
     */
    public String sessionContext() {
        return sessionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackName() == null) ? 0 : stackName().hashCode());
        hashCode = 31 * hashCode + ((fleetName() == null) ? 0 : fleetName().hashCode());
        hashCode = 31 * hashCode + ((userId() == null) ? 0 : userId().hashCode());
        hashCode = 31 * hashCode + ((applicationId() == null) ? 0 : applicationId().hashCode());
        hashCode = 31 * hashCode + ((validity() == null) ? 0 : validity().hashCode());
        hashCode = 31 * hashCode + ((sessionContext() == null) ? 0 : sessionContext().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingURLRequest)) {
            return false;
        }
        CreateStreamingURLRequest other = (CreateStreamingURLRequest) obj;
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.fleetName() == null ^ this.fleetName() == null) {
            return false;
        }
        if (other.fleetName() != null && !other.fleetName().equals(this.fleetName())) {
            return false;
        }
        if (other.userId() == null ^ this.userId() == null) {
            return false;
        }
        if (other.userId() != null && !other.userId().equals(this.userId())) {
            return false;
        }
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.validity() == null ^ this.validity() == null) {
            return false;
        }
        if (other.validity() != null && !other.validity().equals(this.validity())) {
            return false;
        }
        if (other.sessionContext() == null ^ this.sessionContext() == null) {
            return false;
        }
        if (other.sessionContext() != null && !other.sessionContext().equals(this.sessionContext())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (fleetName() != null) {
            sb.append("FleetName: ").append(fleetName()).append(",");
        }
        if (userId() != null) {
            sb.append("UserId: ").append(userId()).append(",");
        }
        if (applicationId() != null) {
            sb.append("ApplicationId: ").append(applicationId()).append(",");
        }
        if (validity() != null) {
            sb.append("Validity: ").append(validity()).append(",");
        }
        if (sessionContext() != null) {
            sb.append("SessionContext: ").append(sessionContext()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.of(clazz.cast(stackName()));
        case "FleetName":
            return Optional.of(clazz.cast(fleetName()));
        case "UserId":
            return Optional.of(clazz.cast(userId()));
        case "ApplicationId":
            return Optional.of(clazz.cast(applicationId()));
        case "Validity":
            return Optional.of(clazz.cast(validity()));
        case "SessionContext":
            return Optional.of(clazz.cast(sessionContext()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateStreamingURLRequest> {
        /**
         * <p>
         * The stack for which the URL is generated.
         * </p>
         * 
         * @param stackName
         *        The stack for which the URL is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The fleet for which the URL is generated.
         * </p>
         * 
         * @param fleetName
         *        The fleet for which the URL is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetName(String fleetName);

        /**
         * <p>
         * A unique user ID for whom the URL is generated.
         * </p>
         * 
         * @param userId
         *        A unique user ID for whom the URL is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The ID of the application that must be launched after the session starts.
         * </p>
         * 
         * @param applicationId
         *        The ID of the application that must be launched after the session starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The duration up to which the URL returned by this action is valid. The input can be any numeric value in
         * seconds between 1 and 604800 seconds.
         * </p>
         * 
         * @param validity
         *        The duration up to which the URL returned by this action is valid. The input can be any numeric value
         *        in seconds between 1 and 604800 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validity(Long validity);

        /**
         * <p>
         * The sessionContext of the streaming URL.
         * </p>
         * 
         * @param sessionContext
         *        The sessionContext of the streaming URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionContext(String sessionContext);
    }

    static final class BuilderImpl implements Builder {
        private String stackName;

        private String fleetName;

        private String userId;

        private String applicationId;

        private Long validity;

        private String sessionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingURLRequest model) {
            stackName(model.stackName);
            fleetName(model.fleetName);
            userId(model.userId);
            applicationId(model.applicationId);
            validity(model.validity);
            sessionContext(model.sessionContext);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getFleetName() {
            return fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final Long getValidity() {
            return validity;
        }

        @Override
        public final Builder validity(Long validity) {
            this.validity = validity;
            return this;
        }

        public final void setValidity(Long validity) {
            this.validity = validity;
        }

        public final String getSessionContext() {
            return sessionContext;
        }

        @Override
        public final Builder sessionContext(String sessionContext) {
            this.sessionContext = sessionContext;
            return this;
        }

        public final void setSessionContext(String sessionContext) {
            this.sessionContext = sessionContext;
        }

        @Override
        public CreateStreamingURLRequest build() {
            return new CreateStreamingURLRequest(this);
        }
    }
}
