/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateFleetResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateFleetResponse.Builder, CreateFleetResponse> {
    private final Fleet fleet;

    private CreateFleetResponse(BuilderImpl builder) {
        this.fleet = builder.fleet;
    }

    /**
     * <p>
     * The details for the created fleet.
     * </p>
     * 
     * @return The details for the created fleet.
     */
    public Fleet fleet() {
        return fleet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((fleet() == null) ? 0 : fleet().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetResponse)) {
            return false;
        }
        CreateFleetResponse other = (CreateFleetResponse) obj;
        if (other.fleet() == null ^ this.fleet() == null) {
            return false;
        }
        if (other.fleet() != null && !other.fleet().equals(this.fleet())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (fleet() != null) {
            sb.append("Fleet: ").append(fleet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fleet":
            return Optional.of(clazz.cast(fleet()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateFleetResponse> {
        /**
         * <p>
         * The details for the created fleet.
         * </p>
         * 
         * @param fleet
         *        The details for the created fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleet(Fleet fleet);
    }

    static final class BuilderImpl implements Builder {
        private Fleet fleet;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetResponse model) {
            fleet(model.fleet);
        }

        public final Fleet.Builder getFleet() {
            return fleet != null ? fleet.toBuilder() : null;
        }

        @Override
        public final Builder fleet(Fleet fleet) {
            this.fleet = fleet;
            return this;
        }

        public final void setFleet(Fleet.BuilderImpl fleet) {
            this.fleet = fleet != null ? fleet.build() : null;
        }

        @Override
        public CreateFleetResponse build() {
            return new CreateFleetResponse(this);
        }
    }
}
