/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.ApplicationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An entry for a single application in the application catalog.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Application implements StructuredPojo, ToCopyableBuilder<Application.Builder, Application> {
    private final String name;

    private final String displayName;

    private final String iconURL;

    private final String launchPath;

    private final String launchParameters;

    private final Boolean enabled;

    private final Map<String, String> metadata;

    private Application(BuilderImpl builder) {
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.iconURL = builder.iconURL;
        this.launchPath = builder.launchPath;
        this.launchParameters = builder.launchParameters;
        this.enabled = builder.enabled;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The unique identifier for the application.
     * </p>
     * 
     * @return The unique identifier for the application.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The name of the application shown to the end users.
     * </p>
     * 
     * @return The name of the application shown to the end users.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The URL for the application icon. This URL may be time-limited.
     * </p>
     * 
     * @return The URL for the application icon. This URL may be time-limited.
     */
    public String iconURL() {
        return iconURL;
    }

    /**
     * <p>
     * The path to the application executable in the instance.
     * </p>
     * 
     * @return The path to the application executable in the instance.
     */
    public String launchPath() {
        return launchPath;
    }

    /**
     * <p>
     * A list of arguments that are passed to the application at launch.
     * </p>
     * 
     * @return A list of arguments that are passed to the application at launch.
     */
    public String launchParameters() {
        return launchParameters;
    }

    /**
     * <p>
     * An application can be disabled after image creation if there is a problem.
     * </p>
     * 
     * @return An application can be disabled after image creation if there is a problem.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Additional attributes that describe the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Additional attributes that describe the application.
     */
    public Map<String, String> metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((displayName() == null) ? 0 : displayName().hashCode());
        hashCode = 31 * hashCode + ((iconURL() == null) ? 0 : iconURL().hashCode());
        hashCode = 31 * hashCode + ((launchPath() == null) ? 0 : launchPath().hashCode());
        hashCode = 31 * hashCode + ((launchParameters() == null) ? 0 : launchParameters().hashCode());
        hashCode = 31 * hashCode + ((enabled() == null) ? 0 : enabled().hashCode());
        hashCode = 31 * hashCode + ((metadata() == null) ? 0 : metadata().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.iconURL() == null ^ this.iconURL() == null) {
            return false;
        }
        if (other.iconURL() != null && !other.iconURL().equals(this.iconURL())) {
            return false;
        }
        if (other.launchPath() == null ^ this.launchPath() == null) {
            return false;
        }
        if (other.launchPath() != null && !other.launchPath().equals(this.launchPath())) {
            return false;
        }
        if (other.launchParameters() == null ^ this.launchParameters() == null) {
            return false;
        }
        if (other.launchParameters() != null && !other.launchParameters().equals(this.launchParameters())) {
            return false;
        }
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.metadata() == null ^ this.metadata() == null) {
            return false;
        }
        if (other.metadata() != null && !other.metadata().equals(this.metadata())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (displayName() != null) {
            sb.append("DisplayName: ").append(displayName()).append(",");
        }
        if (iconURL() != null) {
            sb.append("IconURL: ").append(iconURL()).append(",");
        }
        if (launchPath() != null) {
            sb.append("LaunchPath: ").append(launchPath()).append(",");
        }
        if (launchParameters() != null) {
            sb.append("LaunchParameters: ").append(launchParameters()).append(",");
        }
        if (enabled() != null) {
            sb.append("Enabled: ").append(enabled()).append(",");
        }
        if (metadata() != null) {
            sb.append("Metadata: ").append(metadata()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "DisplayName":
            return Optional.of(clazz.cast(displayName()));
        case "IconURL":
            return Optional.of(clazz.cast(iconURL()));
        case "LaunchPath":
            return Optional.of(clazz.cast(launchPath()));
        case "LaunchParameters":
            return Optional.of(clazz.cast(launchParameters()));
        case "Enabled":
            return Optional.of(clazz.cast(enabled()));
        case "Metadata":
            return Optional.of(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Application> {
        /**
         * <p>
         * The unique identifier for the application.
         * </p>
         * 
         * @param name
         *        The unique identifier for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the application shown to the end users.
         * </p>
         * 
         * @param displayName
         *        The name of the application shown to the end users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The URL for the application icon. This URL may be time-limited.
         * </p>
         * 
         * @param iconURL
         *        The URL for the application icon. This URL may be time-limited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iconURL(String iconURL);

        /**
         * <p>
         * The path to the application executable in the instance.
         * </p>
         * 
         * @param launchPath
         *        The path to the application executable in the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPath(String launchPath);

        /**
         * <p>
         * A list of arguments that are passed to the application at launch.
         * </p>
         * 
         * @param launchParameters
         *        A list of arguments that are passed to the application at launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchParameters(String launchParameters);

        /**
         * <p>
         * An application can be disabled after image creation if there is a problem.
         * </p>
         * 
         * @param enabled
         *        An application can be disabled after image creation if there is a problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Additional attributes that describe the application.
         * </p>
         * 
         * @param metadata
         *        Additional attributes that describe the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, String> metadata);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String displayName;

        private String iconURL;

        private String launchPath;

        private String launchParameters;

        private Boolean enabled;

        private Map<String, String> metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(Application model) {
            name(model.name);
            displayName(model.displayName);
            iconURL(model.iconURL);
            launchPath(model.launchPath);
            launchParameters(model.launchParameters);
            enabled(model.enabled);
            metadata(model.metadata);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getIconURL() {
            return iconURL;
        }

        @Override
        public final Builder iconURL(String iconURL) {
            this.iconURL = iconURL;
            return this;
        }

        public final void setIconURL(String iconURL) {
            this.iconURL = iconURL;
        }

        public final String getLaunchPath() {
            return launchPath;
        }

        @Override
        public final Builder launchPath(String launchPath) {
            this.launchPath = launchPath;
            return this;
        }

        public final void setLaunchPath(String launchPath) {
            this.launchPath = launchPath;
        }

        public final String getLaunchParameters() {
            return launchParameters;
        }

        @Override
        public final Builder launchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
            return this;
        }

        public final void setLaunchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Map<String, String> getMetadata() {
            return metadata;
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
            return this;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
        }

        @Override
        public Application build() {
            return new Application(this);
        }
    }
}
