/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.StorageConnectorMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for a storage connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StorageConnector implements StructuredPojo, ToCopyableBuilder<StorageConnector.Builder, StorageConnector> {
    private final String connectorType;

    private final String resourceIdentifier;

    private StorageConnector(BuilderImpl builder) {
        this.connectorType = builder.connectorType;
        this.resourceIdentifier = builder.resourceIdentifier;
    }

    /**
     * <p>
     * The type of storage connector. The possible values include: HOMEFOLDERS.
     * </p>
     * 
     * @return The type of storage connector. The possible values include: HOMEFOLDERS.
     * @see StorageConnectorType
     */
    public String connectorType() {
        return connectorType;
    }

    /**
     * <p>
     * The ARN associated with the storage connector.
     * </p>
     * 
     * @return The ARN associated with the storage connector.
     */
    public String resourceIdentifier() {
        return resourceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((connectorType() == null) ? 0 : connectorType().hashCode());
        hashCode = 31 * hashCode + ((resourceIdentifier() == null) ? 0 : resourceIdentifier().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageConnector)) {
            return false;
        }
        StorageConnector other = (StorageConnector) obj;
        if (other.connectorType() == null ^ this.connectorType() == null) {
            return false;
        }
        if (other.connectorType() != null && !other.connectorType().equals(this.connectorType())) {
            return false;
        }
        if (other.resourceIdentifier() == null ^ this.resourceIdentifier() == null) {
            return false;
        }
        if (other.resourceIdentifier() != null && !other.resourceIdentifier().equals(this.resourceIdentifier())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (connectorType() != null) {
            sb.append("ConnectorType: ").append(connectorType()).append(",");
        }
        if (resourceIdentifier() != null) {
            sb.append("ResourceIdentifier: ").append(resourceIdentifier()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StorageConnectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StorageConnector> {
        /**
         * <p>
         * The type of storage connector. The possible values include: HOMEFOLDERS.
         * </p>
         * 
         * @param connectorType
         *        The type of storage connector. The possible values include: HOMEFOLDERS.
         * @see StorageConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageConnectorType
         */
        Builder connectorType(String connectorType);

        /**
         * <p>
         * The type of storage connector. The possible values include: HOMEFOLDERS.
         * </p>
         * 
         * @param connectorType
         *        The type of storage connector. The possible values include: HOMEFOLDERS.
         * @see StorageConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageConnectorType
         */
        Builder connectorType(StorageConnectorType connectorType);

        /**
         * <p>
         * The ARN associated with the storage connector.
         * </p>
         * 
         * @param resourceIdentifier
         *        The ARN associated with the storage connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);
    }

    private static final class BuilderImpl implements Builder {
        private String connectorType;

        private String resourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageConnector model) {
            setConnectorType(model.connectorType);
            setResourceIdentifier(model.resourceIdentifier);
        }

        public final String getConnectorType() {
            return connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(StorageConnectorType connectorType) {
            this.connectorType(connectorType.toString());
            return this;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        public final void setConnectorType(StorageConnectorType connectorType) {
            this.connectorType(connectorType.toString());
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public StorageConnector build() {
            return new StorageConnector(this);
        }
    }
}
