/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.FleetErrorMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the fleet error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class FleetError implements StructuredPojo, ToCopyableBuilder<FleetError.Builder, FleetError> {
    private final String errorCode;

    private final String errorMessage;

    private FleetError(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The error code for the fleet error.
     * </p>
     * 
     * @return The error code for the fleet error.
     * @see FleetErrorCode
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error message generated when the fleet has errors.
     * </p>
     * 
     * @return The error message generated when the fleet has errors.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((errorCode() == null) ? 0 : errorCode().hashCode());
        hashCode = 31 * hashCode + ((errorMessage() == null) ? 0 : errorMessage().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetError)) {
            return false;
        }
        FleetError other = (FleetError) obj;
        if (other.errorCode() == null ^ this.errorCode() == null) {
            return false;
        }
        if (other.errorCode() != null && !other.errorCode().equals(this.errorCode())) {
            return false;
        }
        if (other.errorMessage() == null ^ this.errorMessage() == null) {
            return false;
        }
        if (other.errorMessage() != null && !other.errorMessage().equals(this.errorMessage())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (errorCode() != null) {
            sb.append("ErrorCode: ").append(errorCode()).append(",");
        }
        if (errorMessage() != null) {
            sb.append("ErrorMessage: ").append(errorMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FleetErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, FleetError> {
        /**
         * <p>
         * The error code for the fleet error.
         * </p>
         * 
         * @param errorCode
         *        The error code for the fleet error.
         * @see FleetErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error code for the fleet error.
         * </p>
         * 
         * @param errorCode
         *        The error code for the fleet error.
         * @see FleetErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetErrorCode
         */
        Builder errorCode(FleetErrorCode errorCode);

        /**
         * <p>
         * The error message generated when the fleet has errors.
         * </p>
         * 
         * @param errorMessage
         *        The error message generated when the fleet has errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    private static final class BuilderImpl implements Builder {
        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetError model) {
            setErrorCode(model.errorCode);
            setErrorMessage(model.errorMessage);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(FleetErrorCode errorCode) {
            this.errorCode(errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final void setErrorCode(FleetErrorCode errorCode) {
            this.errorCode(errorCode.toString());
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public FleetError build() {
            return new FleetError(this);
        }
    }
}
