/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.UpdateStackRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateStackRequestModelMarshaller {
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> STORAGECONNECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageConnectors").isBinary(false).build();
    private static final MarshallingInfo<Boolean> DELETESTORAGECONNECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeleteStorageConnectors").isBinary(false).build();
    private static final MarshallingInfo<String> REDIRECTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RedirectURL").isBinary(false).build();
    private static final MarshallingInfo<String> FEEDBACKURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FeedbackURL").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTESTODELETE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributesToDelete").isBinary(false).build();
    private static final MarshallingInfo<List> USERSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> APPLICATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationSettings").isBinary(false).build();
    private static final UpdateStackRequestModelMarshaller INSTANCE = new UpdateStackRequestModelMarshaller();

    private UpdateStackRequestModelMarshaller() {
    }

    public static UpdateStackRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateStackRequest updateStackRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateStackRequest), (String)"updateStackRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateStackRequest.displayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall((Object)updateStackRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)updateStackRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall(updateStackRequest.storageConnectors(), STORAGECONNECTORS_BINDING);
            protocolMarshaller.marshall((Object)updateStackRequest.deleteStorageConnectors(), DELETESTORAGECONNECTORS_BINDING);
            protocolMarshaller.marshall((Object)updateStackRequest.redirectURL(), REDIRECTURL_BINDING);
            protocolMarshaller.marshall((Object)updateStackRequest.feedbackURL(), FEEDBACKURL_BINDING);
            protocolMarshaller.marshall(updateStackRequest.attributesToDeleteAsStrings(), ATTRIBUTESTODELETE_BINDING);
            protocolMarshaller.marshall(updateStackRequest.userSettings(), USERSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)updateStackRequest.applicationSettings(), APPLICATIONSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

