/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.ResourceError;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceErrorMarshaller {
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").isBinary(false).build();
    private static final MarshallingInfo<Instant> ERRORTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorTimestamp").isBinary(false).build();
    private static final ResourceErrorMarshaller INSTANCE = new ResourceErrorMarshaller();

    private ResourceErrorMarshaller() {
    }

    public static ResourceErrorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceError resourceError, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceError, (String)"resourceError");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceError.errorCodeAsString(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)resourceError.errorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)resourceError.errorTimestamp(), ERRORTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

