/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.appstream.model.Image;
import software.amazon.awssdk.services.appstream.transform.ApplicationUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.ImagePermissionsUnmarshaller;
import software.amazon.awssdk.services.appstream.transform.ImageStateChangeReasonUnmarshaller;

public class ImageUnmarshaller
implements Unmarshaller<Image, JsonUnmarshallerContext> {
    private static final ImageUnmarshaller INSTANCE = new ImageUnmarshaller();

    public Image unmarshall(JsonUnmarshallerContext context) throws Exception {
        Image.Builder imageBuilder = Image.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    imageBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    imageBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BaseImageArn", targetDepth)) {
                    context.nextToken();
                    imageBuilder.baseImageArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DisplayName", targetDepth)) {
                    context.nextToken();
                    imageBuilder.displayName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("State", targetDepth)) {
                    context.nextToken();
                    imageBuilder.state((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Visibility", targetDepth)) {
                    context.nextToken();
                    imageBuilder.visibility((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ImageBuilderSupported", targetDepth)) {
                    context.nextToken();
                    imageBuilder.imageBuilderSupported((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("Platform", targetDepth)) {
                    context.nextToken();
                    imageBuilder.platform((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    imageBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StateChangeReason", targetDepth)) {
                    context.nextToken();
                    imageBuilder.stateChangeReason(ImageStateChangeReasonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Applications", targetDepth)) {
                    context.nextToken();
                    imageBuilder.applications(new ListUnmarshaller((Unmarshaller)ApplicationUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("CreatedTime", targetDepth)) {
                    context.nextToken();
                    imageBuilder.createdTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("PublicBaseImageReleasedDate", targetDepth)) {
                    context.nextToken();
                    imageBuilder.publicBaseImageReleasedDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("AppstreamAgentVersion", targetDepth)) {
                    context.nextToken();
                    imageBuilder.appstreamAgentVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ImagePermissions", targetDepth)) {
                    context.nextToken();
                    imageBuilder.imagePermissions(ImagePermissionsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Image)imageBuilder.build();
    }

    public static ImageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

