/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.FleetError;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FleetErrorMarshaller {
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").isBinary(false).build();
    private static final FleetErrorMarshaller INSTANCE = new FleetErrorMarshaller();

    private FleetErrorMarshaller() {
    }

    public static FleetErrorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FleetError fleetError, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)fleetError, (String)"fleetError");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)fleetError.errorCodeAsString(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)fleetError.errorMessage(), ERRORMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

