/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.ImagePermissions;
import software.amazon.awssdk.services.appstream.transform.SharedImagePermissionsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SharedImagePermissions
implements StructuredPojo,
ToCopyableBuilder<Builder, SharedImagePermissions> {
    private final String sharedAccountId;
    private final ImagePermissions imagePermissions;

    private SharedImagePermissions(BuilderImpl builder) {
        this.sharedAccountId = builder.sharedAccountId;
        this.imagePermissions = builder.imagePermissions;
    }

    public String sharedAccountId() {
        return this.sharedAccountId;
    }

    public ImagePermissions imagePermissions() {
        return this.imagePermissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePermissions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharedImagePermissions)) {
            return false;
        }
        SharedImagePermissions other = (SharedImagePermissions)obj;
        return Objects.equals(this.sharedAccountId(), other.sharedAccountId()) && Objects.equals(this.imagePermissions(), other.imagePermissions());
    }

    public String toString() {
        return ToString.builder((String)"SharedImagePermissions").add("SharedAccountId", (Object)this.sharedAccountId()).add("ImagePermissions", (Object)this.imagePermissions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sharedAccountId": {
                return Optional.ofNullable(clazz.cast(this.sharedAccountId()));
            }
            case "imagePermissions": {
                return Optional.ofNullable(clazz.cast(this.imagePermissions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SharedImagePermissionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String sharedAccountId;
        private ImagePermissions imagePermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(SharedImagePermissions model) {
            this.sharedAccountId(model.sharedAccountId);
            this.imagePermissions(model.imagePermissions);
        }

        public final String getSharedAccountId() {
            return this.sharedAccountId;
        }

        @Override
        public final Builder sharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
            return this;
        }

        public final void setSharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
        }

        public final ImagePermissions.Builder getImagePermissions() {
            return this.imagePermissions != null ? this.imagePermissions.toBuilder() : null;
        }

        @Override
        public final Builder imagePermissions(ImagePermissions imagePermissions) {
            this.imagePermissions = imagePermissions;
            return this;
        }

        public final void setImagePermissions(ImagePermissions.BuilderImpl imagePermissions) {
            this.imagePermissions = imagePermissions != null ? imagePermissions.build() : null;
        }

        public SharedImagePermissions build() {
            return new SharedImagePermissions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SharedImagePermissions> {
        public Builder sharedAccountId(String var1);

        public Builder imagePermissions(ImagePermissions var1);

        default public Builder imagePermissions(Consumer<ImagePermissions.Builder> imagePermissions) {
            return this.imagePermissions((ImagePermissions)((ImagePermissions.Builder)ImagePermissions.builder().applyMutation(imagePermissions)).build());
        }
    }
}

