/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.UpdateStackRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UpdateStackRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UpdateStackRequestModelMarshaller {
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<List> STORAGECONNECTORS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageConnectors").isBinary(false).build();

    private static final MarshallingInfo<Boolean> DELETESTORAGECONNECTORS_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DeleteStorageConnectors").isBinary(false).build();

    private static final MarshallingInfo<String> REDIRECTURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RedirectURL").isBinary(false).build();

    private static final MarshallingInfo<String> FEEDBACKURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FeedbackURL").isBinary(false).build();

    private static final MarshallingInfo<List> ATTRIBUTESTODELETE_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributesToDelete").isBinary(false).build();

    private static final MarshallingInfo<List> USERSETTINGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserSettings").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> APPLICATIONSETTINGS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ApplicationSettings").isBinary(false).build();

    private static final UpdateStackRequestModelMarshaller INSTANCE = new UpdateStackRequestModelMarshaller();

    private UpdateStackRequestModelMarshaller() {
    }

    public static UpdateStackRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UpdateStackRequest updateStackRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(updateStackRequest, "updateStackRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(updateStackRequest.displayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall(updateStackRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(updateStackRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall(updateStackRequest.storageConnectors(), STORAGECONNECTORS_BINDING);
            protocolMarshaller.marshall(updateStackRequest.deleteStorageConnectors(), DELETESTORAGECONNECTORS_BINDING);
            protocolMarshaller.marshall(updateStackRequest.redirectURL(), REDIRECTURL_BINDING);
            protocolMarshaller.marshall(updateStackRequest.feedbackURL(), FEEDBACKURL_BINDING);
            protocolMarshaller.marshall(updateStackRequest.attributesToDeleteAsStrings(), ATTRIBUTESTODELETE_BINDING);
            protocolMarshaller.marshall(updateStackRequest.userSettings(), USERSETTINGS_BINDING);
            protocolMarshaller.marshall(updateStackRequest.applicationSettings(), APPLICATIONSETTINGS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
