/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.CopyImageRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CopyImageRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CopyImageRequestModelMarshaller {
    private static final MarshallingInfo<String> SOURCEIMAGENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceImageName").isBinary(false).build();

    private static final MarshallingInfo<String> DESTINATIONIMAGENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationImageName").isBinary(false).build();

    private static final MarshallingInfo<String> DESTINATIONREGION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationRegion").isBinary(false).build();

    private static final MarshallingInfo<String> DESTINATIONIMAGEDESCRIPTION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DestinationImageDescription").isBinary(false).build();

    private static final CopyImageRequestModelMarshaller INSTANCE = new CopyImageRequestModelMarshaller();

    private CopyImageRequestModelMarshaller() {
    }

    public static CopyImageRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CopyImageRequest copyImageRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(copyImageRequest, "copyImageRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(copyImageRequest.sourceImageName(), SOURCEIMAGENAME_BINDING);
            protocolMarshaller.marshall(copyImageRequest.destinationImageName(), DESTINATIONIMAGENAME_BINDING);
            protocolMarshaller.marshall(copyImageRequest.destinationRegion(), DESTINATIONREGION_BINDING);
            protocolMarshaller.marshall(copyImageRequest.destinationImageDescription(), DESTINATIONIMAGEDESCRIPTION_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
