/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.ApplicationSettingsResponse;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ApplicationSettingsResponse} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ApplicationSettingsResponseMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();

    private static final MarshallingInfo<String> SETTINGSGROUP_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SettingsGroup").isBinary(false).build();

    private static final MarshallingInfo<String> S3BUCKETNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BucketName").isBinary(false).build();

    private static final ApplicationSettingsResponseMarshaller INSTANCE = new ApplicationSettingsResponseMarshaller();

    private ApplicationSettingsResponseMarshaller() {
    }

    public static ApplicationSettingsResponseMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ApplicationSettingsResponse applicationSettingsResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(applicationSettingsResponse, "applicationSettingsResponse");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(applicationSettingsResponse.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall(applicationSettingsResponse.settingsGroup(), SETTINGSGROUP_BINDING);
            protocolMarshaller.marshall(applicationSettingsResponse.s3BucketName(), S3BUCKETNAME_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
