/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateImagePermissionsRequest extends AppStreamRequest implements
        ToCopyableBuilder<UpdateImagePermissionsRequest.Builder, UpdateImagePermissionsRequest> {
    private final String name;

    private final String sharedAccountId;

    private final ImagePermissions imagePermissions;

    private UpdateImagePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.sharedAccountId = builder.sharedAccountId;
        this.imagePermissions = builder.imagePermissions;
    }

    /**
     * <p>
     * The name of the private image.
     * </p>
     * 
     * @return The name of the private image.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The 12-digit ID of the AWS account for which you want add or update image permissions.
     * </p>
     * 
     * @return The 12-digit ID of the AWS account for which you want add or update image permissions.
     */
    public String sharedAccountId() {
        return sharedAccountId;
    }

    /**
     * <p>
     * The permissions for the image.
     * </p>
     * 
     * @return The permissions for the image.
     */
    public ImagePermissions imagePermissions() {
        return imagePermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sharedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(imagePermissions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImagePermissionsRequest)) {
            return false;
        }
        UpdateImagePermissionsRequest other = (UpdateImagePermissionsRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(sharedAccountId(), other.sharedAccountId())
                && Objects.equals(imagePermissions(), other.imagePermissions());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateImagePermissionsRequest").add("Name", name()).add("SharedAccountId", sharedAccountId())
                .add("ImagePermissions", imagePermissions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SharedAccountId":
            return Optional.ofNullable(clazz.cast(sharedAccountId()));
        case "ImagePermissions":
            return Optional.ofNullable(clazz.cast(imagePermissions()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamRequest.Builder, CopyableBuilder<Builder, UpdateImagePermissionsRequest> {
        /**
         * <p>
         * The name of the private image.
         * </p>
         * 
         * @param name
         *        The name of the private image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The 12-digit ID of the AWS account for which you want add or update image permissions.
         * </p>
         * 
         * @param sharedAccountId
         *        The 12-digit ID of the AWS account for which you want add or update image permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAccountId(String sharedAccountId);

        /**
         * <p>
         * The permissions for the image.
         * </p>
         * 
         * @param imagePermissions
         *        The permissions for the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePermissions(ImagePermissions imagePermissions);

        /**
         * <p>
         * The permissions for the image.
         * </p>
         * This is a convenience that creates an instance of the {@link ImagePermissions.Builder} avoiding the need to
         * create one manually via {@link ImagePermissions#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImagePermissions.Builder#build()} is called immediately and its
         * result is passed to {@link #imagePermissions(ImagePermissions)}.
         * 
         * @param imagePermissions
         *        a consumer that will call methods on {@link ImagePermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imagePermissions(ImagePermissions)
         */
        default Builder imagePermissions(Consumer<ImagePermissions.Builder> imagePermissions) {
            return imagePermissions(ImagePermissions.builder().applyMutation(imagePermissions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String name;

        private String sharedAccountId;

        private ImagePermissions imagePermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateImagePermissionsRequest model) {
            super(model);
            name(model.name);
            sharedAccountId(model.sharedAccountId);
            imagePermissions(model.imagePermissions);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSharedAccountId() {
            return sharedAccountId;
        }

        @Override
        public final Builder sharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
            return this;
        }

        public final void setSharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
        }

        public final ImagePermissions.Builder getImagePermissions() {
            return imagePermissions != null ? imagePermissions.toBuilder() : null;
        }

        @Override
        public final Builder imagePermissions(ImagePermissions imagePermissions) {
            this.imagePermissions = imagePermissions;
            return this;
        }

        public final void setImagePermissions(ImagePermissions.BuilderImpl imagePermissions) {
            this.imagePermissions = imagePermissions != null ? imagePermissions.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateImagePermissionsRequest build() {
            return new UpdateImagePermissionsRequest(this);
        }
    }
}
