/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.SharedImagePermissionsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the permissions that are available to the specified AWS account for a shared image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SharedImagePermissions implements StructuredPojo,
        ToCopyableBuilder<SharedImagePermissions.Builder, SharedImagePermissions> {
    private final String sharedAccountId;

    private final ImagePermissions imagePermissions;

    private SharedImagePermissions(BuilderImpl builder) {
        this.sharedAccountId = builder.sharedAccountId;
        this.imagePermissions = builder.imagePermissions;
    }

    /**
     * <p>
     * The 12-digit ID of the AWS account with which the image is shared.
     * </p>
     * 
     * @return The 12-digit ID of the AWS account with which the image is shared.
     */
    public String sharedAccountId() {
        return sharedAccountId;
    }

    /**
     * <p>
     * Describes the permissions for a shared image.
     * </p>
     * 
     * @return Describes the permissions for a shared image.
     */
    public ImagePermissions imagePermissions() {
        return imagePermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sharedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(imagePermissions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharedImagePermissions)) {
            return false;
        }
        SharedImagePermissions other = (SharedImagePermissions) obj;
        return Objects.equals(sharedAccountId(), other.sharedAccountId())
                && Objects.equals(imagePermissions(), other.imagePermissions());
    }

    @Override
    public String toString() {
        return ToString.builder("SharedImagePermissions").add("SharedAccountId", sharedAccountId())
                .add("ImagePermissions", imagePermissions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sharedAccountId":
            return Optional.ofNullable(clazz.cast(sharedAccountId()));
        case "imagePermissions":
            return Optional.ofNullable(clazz.cast(imagePermissions()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SharedImagePermissionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SharedImagePermissions> {
        /**
         * <p>
         * The 12-digit ID of the AWS account with which the image is shared.
         * </p>
         * 
         * @param sharedAccountId
         *        The 12-digit ID of the AWS account with which the image is shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAccountId(String sharedAccountId);

        /**
         * <p>
         * Describes the permissions for a shared image.
         * </p>
         * 
         * @param imagePermissions
         *        Describes the permissions for a shared image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePermissions(ImagePermissions imagePermissions);

        /**
         * <p>
         * Describes the permissions for a shared image.
         * </p>
         * This is a convenience that creates an instance of the {@link ImagePermissions.Builder} avoiding the need to
         * create one manually via {@link ImagePermissions#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImagePermissions.Builder#build()} is called immediately and its
         * result is passed to {@link #imagePermissions(ImagePermissions)}.
         * 
         * @param imagePermissions
         *        a consumer that will call methods on {@link ImagePermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imagePermissions(ImagePermissions)
         */
        default Builder imagePermissions(Consumer<ImagePermissions.Builder> imagePermissions) {
            return imagePermissions(ImagePermissions.builder().applyMutation(imagePermissions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sharedAccountId;

        private ImagePermissions imagePermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(SharedImagePermissions model) {
            sharedAccountId(model.sharedAccountId);
            imagePermissions(model.imagePermissions);
        }

        public final String getSharedAccountId() {
            return sharedAccountId;
        }

        @Override
        public final Builder sharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
            return this;
        }

        public final void setSharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
        }

        public final ImagePermissions.Builder getImagePermissions() {
            return imagePermissions != null ? imagePermissions.toBuilder() : null;
        }

        @Override
        public final Builder imagePermissions(ImagePermissions imagePermissions) {
            this.imagePermissions = imagePermissions;
            return this;
        }

        public final void setImagePermissions(ImagePermissions.BuilderImpl imagePermissions) {
            this.imagePermissions = imagePermissions != null ? imagePermissions.build() : null;
        }

        @Override
        public SharedImagePermissions build() {
            return new SharedImagePermissions(this);
        }
    }
}
