/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.NetworkAccessConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The network details of the fleet instance for the streaming session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkAccessConfiguration implements StructuredPojo,
        ToCopyableBuilder<NetworkAccessConfiguration.Builder, NetworkAccessConfiguration> {
    private final String eniPrivateIpAddress;

    private final String eniId;

    private NetworkAccessConfiguration(BuilderImpl builder) {
        this.eniPrivateIpAddress = builder.eniPrivateIpAddress;
        this.eniId = builder.eniId;
    }

    /**
     * <p>
     * The private IP address of the elastic network interface that is attached to instances in your VPC.
     * </p>
     * 
     * @return The private IP address of the elastic network interface that is attached to instances in your VPC.
     */
    public String eniPrivateIpAddress() {
        return eniPrivateIpAddress;
    }

    /**
     * <p>
     * The resource identifier of the elastic network interface that is attached to instances in your VPC. All network
     * interfaces have the eni-xxxxxxxx resource identifier.
     * </p>
     * 
     * @return The resource identifier of the elastic network interface that is attached to instances in your VPC. All
     *         network interfaces have the eni-xxxxxxxx resource identifier.
     */
    public String eniId() {
        return eniId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eniPrivateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(eniId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAccessConfiguration)) {
            return false;
        }
        NetworkAccessConfiguration other = (NetworkAccessConfiguration) obj;
        return Objects.equals(eniPrivateIpAddress(), other.eniPrivateIpAddress()) && Objects.equals(eniId(), other.eniId());
    }

    @Override
    public String toString() {
        return ToString.builder("NetworkAccessConfiguration").add("EniPrivateIpAddress", eniPrivateIpAddress())
                .add("EniId", eniId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EniPrivateIpAddress":
            return Optional.ofNullable(clazz.cast(eniPrivateIpAddress()));
        case "EniId":
            return Optional.ofNullable(clazz.cast(eniId()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkAccessConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, NetworkAccessConfiguration> {
        /**
         * <p>
         * The private IP address of the elastic network interface that is attached to instances in your VPC.
         * </p>
         * 
         * @param eniPrivateIpAddress
         *        The private IP address of the elastic network interface that is attached to instances in your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eniPrivateIpAddress(String eniPrivateIpAddress);

        /**
         * <p>
         * The resource identifier of the elastic network interface that is attached to instances in your VPC. All
         * network interfaces have the eni-xxxxxxxx resource identifier.
         * </p>
         * 
         * @param eniId
         *        The resource identifier of the elastic network interface that is attached to instances in your VPC.
         *        All network interfaces have the eni-xxxxxxxx resource identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eniId(String eniId);
    }

    static final class BuilderImpl implements Builder {
        private String eniPrivateIpAddress;

        private String eniId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAccessConfiguration model) {
            eniPrivateIpAddress(model.eniPrivateIpAddress);
            eniId(model.eniId);
        }

        public final String getEniPrivateIpAddress() {
            return eniPrivateIpAddress;
        }

        @Override
        public final Builder eniPrivateIpAddress(String eniPrivateIpAddress) {
            this.eniPrivateIpAddress = eniPrivateIpAddress;
            return this;
        }

        public final void setEniPrivateIpAddress(String eniPrivateIpAddress) {
            this.eniPrivateIpAddress = eniPrivateIpAddress;
        }

        public final String getEniId() {
            return eniId;
        }

        @Override
        public final Builder eniId(String eniId) {
            this.eniId = eniId;
            return this;
        }

        public final void setEniId(String eniId) {
            this.eniId = eniId;
        }

        @Override
        public NetworkAccessConfiguration build() {
            return new NetworkAccessConfiguration(this);
        }
    }
}
