/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSessionsResponse extends AppStreamResponse implements
        ToCopyableBuilder<DescribeSessionsResponse.Builder, DescribeSessionsResponse> {
    private final List<Session> sessions;

    private final String nextToken;

    private DescribeSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.sessions = builder.sessions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the streaming sessions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the streaming sessions.
     */
    public List<Session> sessions() {
        return sessions;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSessionsResponse)) {
            return false;
        }
        DescribeSessionsResponse other = (DescribeSessionsResponse) obj;
        return Objects.equals(sessions(), other.sessions()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeSessionsResponse").add("Sessions", sessions()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sessions":
            return Optional.ofNullable(clazz.cast(sessions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamResponse.Builder, CopyableBuilder<Builder, DescribeSessionsResponse> {
        /**
         * <p>
         * Information about the streaming sessions.
         * </p>
         * 
         * @param sessions
         *        Information about the streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessions(Collection<Session> sessions);

        /**
         * <p>
         * Information about the streaming sessions.
         * </p>
         * 
         * @param sessions
         *        Information about the streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessions(Session... sessions);

        /**
         * <p>
         * Information about the streaming sessions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Session>.Builder} avoiding the need to
         * create one manually via {@link List<Session>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Session>.Builder#build()} is called immediately and its
         * result is passed to {@link #sessions(List<Session>)}.
         * 
         * @param sessions
         *        a consumer that will call methods on {@link List<Session>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessions(List<Session>)
         */
        Builder sessions(Consumer<Session.Builder>... sessions);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private List<Session> sessions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSessionsResponse model) {
            super(model);
            sessions(model.sessions);
            nextToken(model.nextToken);
        }

        public final Collection<Session.Builder> getSessions() {
            return sessions != null ? sessions.stream().map(Session::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sessions(Collection<Session> sessions) {
            this.sessions = SessionListCopier.copy(sessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(Session... sessions) {
            sessions(Arrays.asList(sessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(Consumer<Session.Builder>... sessions) {
            sessions(Stream.of(sessions).map(c -> Session.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSessions(Collection<Session.BuilderImpl> sessions) {
            this.sessions = SessionListCopier.copyFromBuilder(sessions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSessionsResponse build() {
            return new DescribeSessionsResponse(this);
        }
    }
}
