/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImageBuildersResponse extends AppStreamResponse implements
        ToCopyableBuilder<DescribeImageBuildersResponse.Builder, DescribeImageBuildersResponse> {
    private final List<ImageBuilder> imageBuilders;

    private final String nextToken;

    private DescribeImageBuildersResponse(BuilderImpl builder) {
        super(builder);
        this.imageBuilders = builder.imageBuilders;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the image builders.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the image builders.
     */
    public List<ImageBuilder> imageBuilders() {
        return imageBuilders;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageBuilders());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageBuildersResponse)) {
            return false;
        }
        DescribeImageBuildersResponse other = (DescribeImageBuildersResponse) obj;
        return Objects.equals(imageBuilders(), other.imageBuilders()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeImageBuildersResponse").add("ImageBuilders", imageBuilders())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageBuilders":
            return Optional.ofNullable(clazz.cast(imageBuilders()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamResponse.Builder, CopyableBuilder<Builder, DescribeImageBuildersResponse> {
        /**
         * <p>
         * Information about the image builders.
         * </p>
         * 
         * @param imageBuilders
         *        Information about the image builders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuilders(Collection<ImageBuilder> imageBuilders);

        /**
         * <p>
         * Information about the image builders.
         * </p>
         * 
         * @param imageBuilders
         *        Information about the image builders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuilders(ImageBuilder... imageBuilders);

        /**
         * <p>
         * Information about the image builders.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImageBuilder>.Builder} avoiding the need to
         * create one manually via {@link List<ImageBuilder>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImageBuilder>.Builder#build()} is called immediately and its
         * result is passed to {@link #imageBuilders(List<ImageBuilder>)}.
         * 
         * @param imageBuilders
         *        a consumer that will call methods on {@link List<ImageBuilder>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageBuilders(List<ImageBuilder>)
         */
        Builder imageBuilders(Consumer<ImageBuilder.Builder>... imageBuilders);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private List<ImageBuilder> imageBuilders = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageBuildersResponse model) {
            super(model);
            imageBuilders(model.imageBuilders);
            nextToken(model.nextToken);
        }

        public final Collection<ImageBuilder.Builder> getImageBuilders() {
            return imageBuilders != null ? imageBuilders.stream().map(ImageBuilder::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder imageBuilders(Collection<ImageBuilder> imageBuilders) {
            this.imageBuilders = ImageBuilderListCopier.copy(imageBuilders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageBuilders(ImageBuilder... imageBuilders) {
            imageBuilders(Arrays.asList(imageBuilders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageBuilders(Consumer<ImageBuilder.Builder>... imageBuilders) {
            imageBuilders(Stream.of(imageBuilders).map(c -> ImageBuilder.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setImageBuilders(Collection<ImageBuilder.BuilderImpl> imageBuilders) {
            this.imageBuilders = ImageBuilderListCopier.copyFromBuilder(imageBuilders);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeImageBuildersResponse build() {
            return new DescribeImageBuildersResponse(this);
        }
    }
}
