/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyImageResponse extends AppStreamResponse implements
        ToCopyableBuilder<CopyImageResponse.Builder, CopyImageResponse> {
    private final String destinationImageName;

    private CopyImageResponse(BuilderImpl builder) {
        super(builder);
        this.destinationImageName = builder.destinationImageName;
    }

    /**
     * <p>
     * The name of the destination image.
     * </p>
     * 
     * @return The name of the destination image.
     */
    public String destinationImageName() {
        return destinationImageName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationImageName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyImageResponse)) {
            return false;
        }
        CopyImageResponse other = (CopyImageResponse) obj;
        return Objects.equals(destinationImageName(), other.destinationImageName());
    }

    @Override
    public String toString() {
        return ToString.builder("CopyImageResponse").add("DestinationImageName", destinationImageName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationImageName":
            return Optional.ofNullable(clazz.cast(destinationImageName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamResponse.Builder, CopyableBuilder<Builder, CopyImageResponse> {
        /**
         * <p>
         * The name of the destination image.
         * </p>
         * 
         * @param destinationImageName
         *        The name of the destination image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationImageName(String destinationImageName);
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private String destinationImageName;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyImageResponse model) {
            super(model);
            destinationImageName(model.destinationImageName);
        }

        public final String getDestinationImageName() {
            return destinationImageName;
        }

        @Override
        public final Builder destinationImageName(String destinationImageName) {
            this.destinationImageName = destinationImageName;
            return this;
        }

        public final void setDestinationImageName(String destinationImageName) {
            this.destinationImageName = destinationImageName;
        }

        @Override
        public CopyImageResponse build() {
            return new CopyImageResponse(this);
        }
    }
}
