/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.ApplicationSettingsResponseMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the persistent application settings for users of a stack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationSettingsResponse implements StructuredPojo,
        ToCopyableBuilder<ApplicationSettingsResponse.Builder, ApplicationSettingsResponse> {
    private final Boolean enabled;

    private final String settingsGroup;

    private final String s3BucketName;

    private ApplicationSettingsResponse(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.settingsGroup = builder.settingsGroup;
        this.s3BucketName = builder.s3BucketName;
    }

    /**
     * <p>
     * Specifies whether persistent application settings are enabled for users during their streaming sessions.
     * </p>
     * 
     * @return Specifies whether persistent application settings are enabled for users during their streaming sessions.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The path prefix for the S3 bucket where users’ persistent application settings are stored.
     * </p>
     * 
     * @return The path prefix for the S3 bucket where users’ persistent application settings are stored.
     */
    public String settingsGroup() {
        return settingsGroup;
    }

    /**
     * <p>
     * The S3 bucket where users’ persistent application settings are stored. When persistent application settings are
     * enabled for the first time for an account in an AWS Region, an S3 bucket is created. The bucket is unique to the
     * AWS account and the Region.
     * </p>
     * 
     * @return The S3 bucket where users’ persistent application settings are stored. When persistent application
     *         settings are enabled for the first time for an account in an AWS Region, an S3 bucket is created. The
     *         bucket is unique to the AWS account and the Region.
     */
    public String s3BucketName() {
        return s3BucketName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(settingsGroup());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSettingsResponse)) {
            return false;
        }
        ApplicationSettingsResponse other = (ApplicationSettingsResponse) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(settingsGroup(), other.settingsGroup())
                && Objects.equals(s3BucketName(), other.s3BucketName());
    }

    @Override
    public String toString() {
        return ToString.builder("ApplicationSettingsResponse").add("Enabled", enabled()).add("SettingsGroup", settingsGroup())
                .add("S3BucketName", s3BucketName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "SettingsGroup":
            return Optional.ofNullable(clazz.cast(settingsGroup()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationSettingsResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ApplicationSettingsResponse> {
        /**
         * <p>
         * Specifies whether persistent application settings are enabled for users during their streaming sessions.
         * </p>
         * 
         * @param enabled
         *        Specifies whether persistent application settings are enabled for users during their streaming
         *        sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The path prefix for the S3 bucket where users’ persistent application settings are stored.
         * </p>
         * 
         * @param settingsGroup
         *        The path prefix for the S3 bucket where users’ persistent application settings are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settingsGroup(String settingsGroup);

        /**
         * <p>
         * The S3 bucket where users’ persistent application settings are stored. When persistent application settings
         * are enabled for the first time for an account in an AWS Region, an S3 bucket is created. The bucket is unique
         * to the AWS account and the Region.
         * </p>
         * 
         * @param s3BucketName
         *        The S3 bucket where users’ persistent application settings are stored. When persistent application
         *        settings are enabled for the first time for an account in an AWS Region, an S3 bucket is created. The
         *        bucket is unique to the AWS account and the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String settingsGroup;

        private String s3BucketName;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSettingsResponse model) {
            enabled(model.enabled);
            settingsGroup(model.settingsGroup);
            s3BucketName(model.s3BucketName);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getSettingsGroup() {
            return settingsGroup;
        }

        @Override
        public final Builder settingsGroup(String settingsGroup) {
            this.settingsGroup = settingsGroup;
            return this;
        }

        public final void setSettingsGroup(String settingsGroup) {
            this.settingsGroup = settingsGroup;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public ApplicationSettingsResponse build() {
            return new ApplicationSettingsResponse(this);
        }
    }
}
