/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.ApplicationSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The persistent application settings for users of a stack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationSettings implements StructuredPojo,
        ToCopyableBuilder<ApplicationSettings.Builder, ApplicationSettings> {
    private final Boolean enabled;

    private final String settingsGroup;

    private ApplicationSettings(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.settingsGroup = builder.settingsGroup;
    }

    /**
     * <p>
     * Enables or disables persistent application settings for users during their streaming sessions.
     * </p>
     * 
     * @return Enables or disables persistent application settings for users during their streaming sessions.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The path prefix for the S3 bucket where users’ persistent application settings are stored. You can allow the same
     * persistent application settings to be used across multiple stacks by specifying the same settings group for each
     * stack.
     * </p>
     * 
     * @return The path prefix for the S3 bucket where users’ persistent application settings are stored. You can allow
     *         the same persistent application settings to be used across multiple stacks by specifying the same
     *         settings group for each stack.
     */
    public String settingsGroup() {
        return settingsGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(settingsGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSettings)) {
            return false;
        }
        ApplicationSettings other = (ApplicationSettings) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(settingsGroup(), other.settingsGroup());
    }

    @Override
    public String toString() {
        return ToString.builder("ApplicationSettings").add("Enabled", enabled()).add("SettingsGroup", settingsGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "SettingsGroup":
            return Optional.ofNullable(clazz.cast(settingsGroup()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ApplicationSettings> {
        /**
         * <p>
         * Enables or disables persistent application settings for users during their streaming sessions.
         * </p>
         * 
         * @param enabled
         *        Enables or disables persistent application settings for users during their streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The path prefix for the S3 bucket where users’ persistent application settings are stored. You can allow the
         * same persistent application settings to be used across multiple stacks by specifying the same settings group
         * for each stack.
         * </p>
         * 
         * @param settingsGroup
         *        The path prefix for the S3 bucket where users’ persistent application settings are stored. You can
         *        allow the same persistent application settings to be used across multiple stacks by specifying the
         *        same settings group for each stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settingsGroup(String settingsGroup);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String settingsGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSettings model) {
            enabled(model.enabled);
            settingsGroup(model.settingsGroup);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getSettingsGroup() {
            return settingsGroup;
        }

        @Override
        public final Builder settingsGroup(String settingsGroup) {
            this.settingsGroup = settingsGroup;
            return this;
        }

        public final void setSettingsGroup(String settingsGroup) {
            this.settingsGroup = settingsGroup;
        }

        @Override
        public ApplicationSettings build() {
            return new ApplicationSettings(this);
        }
    }
}
