/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderStreamingUrlRequest;
import software.amazon.awssdk.services.appstream.transform.CreateImageBuilderStreamingUrlRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateImageBuilderStreamingUrlRequestMarshaller
implements Marshaller<Request<CreateImageBuilderStreamingUrlRequest>, CreateImageBuilderStreamingUrlRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("PhotonAdminProxyService.CreateImageBuilderStreamingURL").serviceName("Amazon AppStream").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public CreateImageBuilderStreamingUrlRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateImageBuilderStreamingUrlRequest> marshall(CreateImageBuilderStreamingUrlRequest createImageBuilderStreamingUrlRequest) {
        Validate.paramNotNull((Object)((Object)createImageBuilderStreamingUrlRequest), (String)"createImageBuilderStreamingUrlRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)createImageBuilderStreamingUrlRequest);
            protocolMarshaller.startMarshalling();
            CreateImageBuilderStreamingUrlRequestModelMarshaller.getInstance().marshall(createImageBuilderStreamingUrlRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

