/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.FleetErrorCode;
import software.amazon.awssdk.services.appstream.transform.ResourceErrorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceError
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceError> {
    private final String errorCode;
    private final String errorMessage;
    private final Instant errorTimestamp;

    private ResourceError(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.errorTimestamp = builder.errorTimestamp;
    }

    public FleetErrorCode errorCode() {
        return FleetErrorCode.fromValue(this.errorCode);
    }

    public String errorCodeAsString() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Instant errorTimestamp() {
        return this.errorTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceError)) {
            return false;
        }
        ResourceError other = (ResourceError)obj;
        return Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.errorTimestamp(), other.errorTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"ResourceError").add("ErrorCode", (Object)this.errorCodeAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("ErrorTimestamp", (Object)this.errorTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "ErrorTimestamp": {
                return Optional.ofNullable(clazz.cast(this.errorTimestamp()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorCode;
        private String errorMessage;
        private Instant errorTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceError model) {
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
            this.errorTimestamp(model.errorTimestamp);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(FleetErrorCode errorCode) {
            this.errorCode(errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Instant getErrorTimestamp() {
            return this.errorTimestamp;
        }

        @Override
        public final Builder errorTimestamp(Instant errorTimestamp) {
            this.errorTimestamp = errorTimestamp;
            return this;
        }

        public final void setErrorTimestamp(Instant errorTimestamp) {
            this.errorTimestamp = errorTimestamp;
        }

        public ResourceError build() {
            return new ResourceError(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceError> {
        public Builder errorCode(String var1);

        public Builder errorCode(FleetErrorCode var1);

        public Builder errorMessage(String var1);

        public Builder errorTimestamp(Instant var1);
    }
}

