/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.StorageConnector;
import software.amazon.awssdk.services.appstream.model.StorageConnectorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStackRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, CreateStackRequest> {
    private final String name;
    private final String description;
    private final String displayName;
    private final List<StorageConnector> storageConnectors;

    private CreateStackRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.storageConnectors = builder.storageConnectors;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String displayName() {
        return this.displayName;
    }

    public List<StorageConnector> storageConnectors() {
        return this.storageConnectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageConnectors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRequest)) {
            return false;
        }
        CreateStackRequest other = (CreateStackRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.storageConnectors(), other.storageConnectors());
    }

    public String toString() {
        return ToString.builder((String)"CreateStackRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("StorageConnectors", this.storageConnectors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "StorageConnectors": {
                return Optional.ofNullable(clazz.cast(this.storageConnectors()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String displayName;
        private List<StorageConnector> storageConnectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.displayName(model.displayName);
            this.storageConnectors(model.storageConnectors);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Collection<StorageConnector.Builder> getStorageConnectors() {
            return this.storageConnectors != null ? (Collection)this.storageConnectors.stream().map(StorageConnector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector ... storageConnectors) {
            this.storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(Consumer<StorageConnector.Builder> ... storageConnectors) {
            this.storageConnectors(Stream.of(storageConnectors).map(c -> (StorageConnector)((StorageConnector.Builder)StorageConnector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStorageConnectors(Collection<StorageConnector.BuilderImpl> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copyFromBuilder(storageConnectors);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStackRequest build() {
            return new CreateStackRequest(this);
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    CopyableBuilder<Builder, CreateStackRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder storageConnectors(Collection<StorageConnector> var1);

        public Builder storageConnectors(StorageConnector ... var1);

        public Builder storageConnectors(Consumer<StorageConnector.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

