/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderStreamingUrlRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateImageBuilderStreamingUrlRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateImageBuilderStreamingUrlRequestModelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<Long> VALIDITY_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Validity").isBinary(false).build();

    private static final CreateImageBuilderStreamingUrlRequestModelMarshaller INSTANCE = new CreateImageBuilderStreamingUrlRequestModelMarshaller();

    private CreateImageBuilderStreamingUrlRequestModelMarshaller() {
    }

    public static CreateImageBuilderStreamingUrlRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateImageBuilderStreamingUrlRequest createImageBuilderStreamingUrlRequest,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createImageBuilderStreamingUrlRequest, "createImageBuilderStreamingUrlRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createImageBuilderStreamingUrlRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall(createImageBuilderStreamingUrlRequest.validity(), VALIDITY_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
