/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStackRequest extends AppStreamRequest implements
        ToCopyableBuilder<UpdateStackRequest.Builder, UpdateStackRequest> {
    private final String displayName;

    private final String description;

    private final String name;

    private final List<StorageConnector> storageConnectors;

    private final Boolean deleteStorageConnectors;

    private UpdateStackRequest(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.name = builder.name;
        this.storageConnectors = builder.storageConnectors;
        this.deleteStorageConnectors = builder.deleteStorageConnectors;
    }

    /**
     * <p>
     * The stack name displayed to end users.
     * </p>
     * 
     * @return The stack name displayed to end users.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description displayed to end users.
     * </p>
     * 
     * @return The description displayed to end users.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The name of the stack.
     * </p>
     * 
     * @return The name of the stack.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The storage connectors to enable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The storage connectors to enable.
     */
    public List<StorageConnector> storageConnectors() {
        return storageConnectors;
    }

    /**
     * <p>
     * Deletes the storage connectors currently enabled for the stack.
     * </p>
     * 
     * @return Deletes the storage connectors currently enabled for the stack.
     */
    public Boolean deleteStorageConnectors() {
        return deleteStorageConnectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(storageConnectors());
        hashCode = 31 * hashCode + Objects.hashCode(deleteStorageConnectors());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackRequest)) {
            return false;
        }
        UpdateStackRequest other = (UpdateStackRequest) obj;
        return Objects.equals(displayName(), other.displayName()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name()) && Objects.equals(storageConnectors(), other.storageConnectors())
                && Objects.equals(deleteStorageConnectors(), other.deleteStorageConnectors());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateStackRequest").add("DisplayName", displayName()).add("Description", description())
                .add("Name", name()).add("StorageConnectors", storageConnectors())
                .add("DeleteStorageConnectors", deleteStorageConnectors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "StorageConnectors":
            return Optional.ofNullable(clazz.cast(storageConnectors()));
        case "DeleteStorageConnectors":
            return Optional.ofNullable(clazz.cast(deleteStorageConnectors()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamRequest.Builder, CopyableBuilder<Builder, UpdateStackRequest> {
        /**
         * <p>
         * The stack name displayed to end users.
         * </p>
         * 
         * @param displayName
         *        The stack name displayed to end users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description displayed to end users.
         * </p>
         * 
         * @param description
         *        The description displayed to end users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the stack.
         * </p>
         * 
         * @param name
         *        The name of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(Collection<StorageConnector> storageConnectors);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(StorageConnector... storageConnectors);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StorageConnector>.Builder} avoiding the
         * need to create one manually via {@link List<StorageConnector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StorageConnector>.Builder#build()} is called immediately and
         * its result is passed to {@link #storageConnectors(List<StorageConnector>)}.
         * 
         * @param storageConnectors
         *        a consumer that will call methods on {@link List<StorageConnector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConnectors(List<StorageConnector>)
         */
        Builder storageConnectors(Consumer<StorageConnector.Builder>... storageConnectors);

        /**
         * <p>
         * Deletes the storage connectors currently enabled for the stack.
         * </p>
         * 
         * @param deleteStorageConnectors
         *        Deletes the storage connectors currently enabled for the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteStorageConnectors(Boolean deleteStorageConnectors);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String displayName;

        private String description;

        private String name;

        private List<StorageConnector> storageConnectors = DefaultSdkAutoConstructList.getInstance();

        private Boolean deleteStorageConnectors;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackRequest model) {
            super(model);
            displayName(model.displayName);
            description(model.description);
            name(model.name);
            storageConnectors(model.storageConnectors);
            deleteStorageConnectors(model.deleteStorageConnectors);
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<StorageConnector.Builder> getStorageConnectors() {
            return storageConnectors != null ? storageConnectors.stream().map(StorageConnector::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector... storageConnectors) {
            storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(Consumer<StorageConnector.Builder>... storageConnectors) {
            storageConnectors(Stream.of(storageConnectors).map(c -> StorageConnector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStorageConnectors(Collection<StorageConnector.BuilderImpl> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copyFromBuilder(storageConnectors);
        }

        public final Boolean getDeleteStorageConnectors() {
            return deleteStorageConnectors;
        }

        @Override
        public final Builder deleteStorageConnectors(Boolean deleteStorageConnectors) {
            this.deleteStorageConnectors = deleteStorageConnectors;
            return this;
        }

        public final void setDeleteStorageConnectors(Boolean deleteStorageConnectors) {
            this.deleteStorageConnectors = deleteStorageConnectors;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStackRequest build() {
            return new UpdateStackRequest(this);
        }
    }
}
