/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.ImageBuilderStateChangeReasonMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageBuilderStateChangeReason implements StructuredPojo,
        ToCopyableBuilder<ImageBuilderStateChangeReason.Builder, ImageBuilderStateChangeReason> {
    private final String code;

    private final String message;

    private ImageBuilderStateChangeReason(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * Returns the value of the Code property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ImageBuilderStateChangeReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #codeAsString}.
     * </p>
     * 
     * @return The value of the Code property for this object.
     * @see ImageBuilderStateChangeReasonCode
     */
    public ImageBuilderStateChangeReasonCode code() {
        return ImageBuilderStateChangeReasonCode.fromValue(code);
    }

    /**
     * Returns the value of the Code property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ImageBuilderStateChangeReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #codeAsString}.
     * </p>
     * 
     * @return The value of the Code property for this object.
     * @see ImageBuilderStateChangeReasonCode
     */
    public String codeAsString() {
        return code;
    }

    /**
     * Returns the value of the Message property for this object.
     * 
     * @return The value of the Message property for this object.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageBuilderStateChangeReason)) {
            return false;
        }
        ImageBuilderStateChangeReason other = (ImageBuilderStateChangeReason) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(message(), other.message());
    }

    @Override
    public String toString() {
        return ToString.builder("ImageBuilderStateChangeReason").add("Code", codeAsString()).add("Message", message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageBuilderStateChangeReasonMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ImageBuilderStateChangeReason> {
        /**
         * Sets the value of the Code property for this object.
         *
         * @param code
         *        The new value for the Code property for this object.
         * @see ImageBuilderStateChangeReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageBuilderStateChangeReasonCode
         */
        Builder code(String code);

        /**
         * Sets the value of the Code property for this object.
         *
         * @param code
         *        The new value for the Code property for this object.
         * @see ImageBuilderStateChangeReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageBuilderStateChangeReasonCode
         */
        Builder code(ImageBuilderStateChangeReasonCode code);

        /**
         * Sets the value of the Message property for this object.
         *
         * @param message
         *        The new value for the Message property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageBuilderStateChangeReason model) {
            code(model.code);
            message(model.message);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(ImageBuilderStateChangeReasonCode code) {
            this.code(code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public ImageBuilderStateChangeReason build() {
            return new ImageBuilderStateChangeReason(this);
        }
    }
}
