/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.appstream.model.AppStreamException;
import software.amazon.awssdk.services.appstream.model.AssociateFleetRequest;
import software.amazon.awssdk.services.appstream.model.AssociateFleetResponse;
import software.amazon.awssdk.services.appstream.model.ConcurrentModificationException;
import software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigRequest;
import software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigResponse;
import software.amazon.awssdk.services.appstream.model.CreateFleetRequest;
import software.amazon.awssdk.services.appstream.model.CreateFleetResponse;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderRequest;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderResponse;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderStreamingUrlRequest;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderStreamingUrlResponse;
import software.amazon.awssdk.services.appstream.model.CreateStackRequest;
import software.amazon.awssdk.services.appstream.model.CreateStackResponse;
import software.amazon.awssdk.services.appstream.model.CreateStreamingUrlRequest;
import software.amazon.awssdk.services.appstream.model.CreateStreamingUrlResponse;
import software.amazon.awssdk.services.appstream.model.DeleteDirectoryConfigRequest;
import software.amazon.awssdk.services.appstream.model.DeleteDirectoryConfigResponse;
import software.amazon.awssdk.services.appstream.model.DeleteFleetRequest;
import software.amazon.awssdk.services.appstream.model.DeleteFleetResponse;
import software.amazon.awssdk.services.appstream.model.DeleteImageBuilderRequest;
import software.amazon.awssdk.services.appstream.model.DeleteImageBuilderResponse;
import software.amazon.awssdk.services.appstream.model.DeleteImageRequest;
import software.amazon.awssdk.services.appstream.model.DeleteImageResponse;
import software.amazon.awssdk.services.appstream.model.DeleteStackRequest;
import software.amazon.awssdk.services.appstream.model.DeleteStackResponse;
import software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeImageBuildersRequest;
import software.amazon.awssdk.services.appstream.model.DescribeImageBuildersResponse;
import software.amazon.awssdk.services.appstream.model.DescribeImagesRequest;
import software.amazon.awssdk.services.appstream.model.DescribeImagesResponse;
import software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeSessionsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeStacksRequest;
import software.amazon.awssdk.services.appstream.model.DescribeStacksResponse;
import software.amazon.awssdk.services.appstream.model.DisassociateFleetRequest;
import software.amazon.awssdk.services.appstream.model.DisassociateFleetResponse;
import software.amazon.awssdk.services.appstream.model.ExpireSessionRequest;
import software.amazon.awssdk.services.appstream.model.ExpireSessionResponse;
import software.amazon.awssdk.services.appstream.model.IncompatibleImageException;
import software.amazon.awssdk.services.appstream.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.appstream.model.InvalidRoleException;
import software.amazon.awssdk.services.appstream.model.LimitExceededException;
import software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsRequest;
import software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsResponse;
import software.amazon.awssdk.services.appstream.model.ListAssociatedStacksRequest;
import software.amazon.awssdk.services.appstream.model.ListAssociatedStacksResponse;
import software.amazon.awssdk.services.appstream.model.OperationNotPermittedException;
import software.amazon.awssdk.services.appstream.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.appstream.model.ResourceInUseException;
import software.amazon.awssdk.services.appstream.model.ResourceNotAvailableException;
import software.amazon.awssdk.services.appstream.model.ResourceNotFoundException;
import software.amazon.awssdk.services.appstream.model.StartFleetRequest;
import software.amazon.awssdk.services.appstream.model.StartFleetResponse;
import software.amazon.awssdk.services.appstream.model.StartImageBuilderRequest;
import software.amazon.awssdk.services.appstream.model.StartImageBuilderResponse;
import software.amazon.awssdk.services.appstream.model.StopFleetRequest;
import software.amazon.awssdk.services.appstream.model.StopFleetResponse;
import software.amazon.awssdk.services.appstream.model.StopImageBuilderRequest;
import software.amazon.awssdk.services.appstream.model.StopImageBuilderResponse;
import software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigRequest;
import software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigResponse;
import software.amazon.awssdk.services.appstream.model.UpdateFleetRequest;
import software.amazon.awssdk.services.appstream.model.UpdateFleetResponse;
import software.amazon.awssdk.services.appstream.model.UpdateStackRequest;
import software.amazon.awssdk.services.appstream.model.UpdateStackResponse;

/**
 * Service client for accessing null. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon AppStream 2.0</fullname>
 * <p>
 * You can use Amazon AppStream 2.0 to stream desktop applications to any device running a web browser, without
 * rewriting them.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface AppStreamClient extends SdkClient {
    String SERVICE_NAME = "appstream";

    /**
     * Create a {@link AppStreamClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AppStreamClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AppStreamClient}.
     */
    static AppStreamClientBuilder builder() {
        return new DefaultAppStreamClientBuilder();
    }

    /**
     * <p>
     * Associates the specified fleet with the specified stack.
     * </p>
     *
     * @param associateFleetRequest
     * @return Result of the AssociateFleet operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws IncompatibleImageException
     *         The image does not support storage connectors.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.AssociateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateFleetResponse associateFleet(AssociateFleetRequest associateFleetRequest) throws LimitExceededException,
            ResourceNotFoundException, ConcurrentModificationException, IncompatibleImageException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified fleet with the specified stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link AssociateFleetRequest#builder()}
     * </p>
     *
     * @param associateFleetRequest
     *        A {@link Consumer} that will call methods on {@link AssociateFleetRequest.Builder} to create a request.
     * @return Result of the AssociateFleet operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws IncompatibleImageException
     *         The image does not support storage connectors.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.AssociateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateFleetResponse associateFleet(Consumer<AssociateFleetRequest.Builder> associateFleetRequest)
            throws LimitExceededException, ResourceNotFoundException, ConcurrentModificationException,
            IncompatibleImageException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            AppStreamException {
        return associateFleet(AssociateFleetRequest.builder().applyMutation(associateFleetRequest).build());
    }

    /**
     * <p>
     * Creates a directory configuration.
     * </p>
     *
     * @param createDirectoryConfigRequest
     * @return Result of the CreateDirectoryConfig operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateDirectoryConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDirectoryConfigResponse createDirectoryConfig(CreateDirectoryConfigRequest createDirectoryConfigRequest)
            throws ResourceAlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a directory configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDirectoryConfigRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDirectoryConfigRequest#builder()}
     * </p>
     *
     * @param createDirectoryConfigRequest
     *        A {@link Consumer} that will call methods on {@link CreateDirectoryConfigRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDirectoryConfig operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateDirectoryConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDirectoryConfigResponse createDirectoryConfig(
            Consumer<CreateDirectoryConfigRequest.Builder> createDirectoryConfigRequest) throws ResourceAlreadyExistsException,
            LimitExceededException, AwsServiceException, SdkClientException, AppStreamException {
        return createDirectoryConfig(CreateDirectoryConfigRequest.builder().applyMutation(createDirectoryConfigRequest).build());
    }

    /**
     * <p>
     * Creates a fleet.
     * </p>
     *
     * @param createFleetRequest
     * @return Result of the CreateFleet operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws IncompatibleImageException
     *         The image does not support storage connectors.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFleetResponse createFleet(CreateFleetRequest createFleetRequest) throws ResourceAlreadyExistsException,
            ResourceNotAvailableException, ResourceNotFoundException, LimitExceededException, InvalidRoleException,
            ConcurrentModificationException, InvalidParameterCombinationException, IncompatibleImageException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFleetRequest#builder()}
     * </p>
     *
     * @param createFleetRequest
     *        A {@link Consumer} that will call methods on {@link CreateFleetRequest.Builder} to create a request.
     * @return Result of the CreateFleet operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws IncompatibleImageException
     *         The image does not support storage connectors.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFleetResponse createFleet(Consumer<CreateFleetRequest.Builder> createFleetRequest)
            throws ResourceAlreadyExistsException, ResourceNotAvailableException, ResourceNotFoundException,
            LimitExceededException, InvalidRoleException, ConcurrentModificationException, InvalidParameterCombinationException,
            IncompatibleImageException, AwsServiceException, SdkClientException, AppStreamException {
        return createFleet(CreateFleetRequest.builder().applyMutation(createFleetRequest).build());
    }

    /**
     * Invokes the CreateImageBuilder operation.
     *
     * @param createImageBuilderRequest
     * @return Result of the CreateImageBuilder operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws IncompatibleImageException
     *         The image does not support storage connectors.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateImageBuilder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateImageBuilderResponse createImageBuilder(CreateImageBuilderRequest createImageBuilderRequest)
            throws LimitExceededException, ResourceAlreadyExistsException, ResourceNotAvailableException,
            ResourceNotFoundException, InvalidRoleException, ConcurrentModificationException,
            InvalidParameterCombinationException, IncompatibleImageException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the CreateImageBuilder operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImageBuilderRequest.Builder} avoiding the
     * need to create one manually via {@link CreateImageBuilderRequest#builder()}
     * </p>
     *
     * @param createImageBuilderRequest
     *        A {@link Consumer} that will call methods on {@link CreateImageBuilderRequest.Builder} to create a
     *        request.
     * @return Result of the CreateImageBuilder operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws IncompatibleImageException
     *         The image does not support storage connectors.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateImageBuilder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateImageBuilderResponse createImageBuilder(Consumer<CreateImageBuilderRequest.Builder> createImageBuilderRequest)
            throws LimitExceededException, ResourceAlreadyExistsException, ResourceNotAvailableException,
            ResourceNotFoundException, InvalidRoleException, ConcurrentModificationException,
            InvalidParameterCombinationException, IncompatibleImageException, AwsServiceException, SdkClientException,
            AppStreamException {
        return createImageBuilder(CreateImageBuilderRequest.builder().applyMutation(createImageBuilderRequest).build());
    }

    /**
     * Invokes the CreateImageBuilderStreamingURL operation.
     *
     * @param createImageBuilderStreamingUrlRequest
     * @return Result of the CreateImageBuilderStreamingURL operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateImageBuilderStreamingURL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilderStreamingURL"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateImageBuilderStreamingUrlResponse createImageBuilderStreamingURL(
            CreateImageBuilderStreamingUrlRequest createImageBuilderStreamingUrlRequest) throws OperationNotPermittedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the CreateImageBuilderStreamingURL operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImageBuilderStreamingUrlRequest.Builder}
     * avoiding the need to create one manually via {@link CreateImageBuilderStreamingUrlRequest#builder()}
     * </p>
     *
     * @param createImageBuilderStreamingUrlRequest
     *        A {@link Consumer} that will call methods on {@link CreateImageBuilderStreamingURLRequest.Builder} to
     *        create a request.
     * @return Result of the CreateImageBuilderStreamingURL operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateImageBuilderStreamingURL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilderStreamingURL"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateImageBuilderStreamingUrlResponse createImageBuilderStreamingURL(
            Consumer<CreateImageBuilderStreamingUrlRequest.Builder> createImageBuilderStreamingUrlRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        return createImageBuilderStreamingURL(CreateImageBuilderStreamingUrlRequest.builder()
                .applyMutation(createImageBuilderStreamingUrlRequest).build());
    }

    /**
     * <p>
     * Creates a stack.
     * </p>
     *
     * @param createStackRequest
     * @return Result of the CreateStack operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateStackResponse createStack(CreateStackRequest createStackRequest) throws LimitExceededException,
            ResourceAlreadyExistsException, ConcurrentModificationException, InvalidRoleException, ResourceNotFoundException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStackRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStackRequest#builder()}
     * </p>
     *
     * @param createStackRequest
     *        A {@link Consumer} that will call methods on {@link CreateStackRequest.Builder} to create a request.
     * @return Result of the CreateStack operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateStackResponse createStack(Consumer<CreateStackRequest.Builder> createStackRequest)
            throws LimitExceededException, ResourceAlreadyExistsException, ConcurrentModificationException, InvalidRoleException,
            ResourceNotFoundException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            AppStreamException {
        return createStack(CreateStackRequest.builder().applyMutation(createStackRequest).build());
    }

    /**
     * <p>
     * Creates a URL to start a streaming session for the specified user.
     * </p>
     * <p>
     * By default, the URL is valid only for one minute from the time that it is generated.
     * </p>
     *
     * @param createStreamingUrlRequest
     * @return Result of the CreateStreamingURL operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateStreamingURL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStreamingURL" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateStreamingUrlResponse createStreamingURL(CreateStreamingUrlRequest createStreamingUrlRequest)
            throws ResourceNotFoundException, ResourceNotAvailableException, OperationNotPermittedException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a URL to start a streaming session for the specified user.
     * </p>
     * <p>
     * By default, the URL is valid only for one minute from the time that it is generated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamingUrlRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStreamingUrlRequest#builder()}
     * </p>
     *
     * @param createStreamingUrlRequest
     *        A {@link Consumer} that will call methods on {@link CreateStreamingURLRequest.Builder} to create a
     *        request.
     * @return Result of the CreateStreamingURL operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateStreamingURL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStreamingURL" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateStreamingUrlResponse createStreamingURL(Consumer<CreateStreamingUrlRequest.Builder> createStreamingUrlRequest)
            throws ResourceNotFoundException, ResourceNotAvailableException, OperationNotPermittedException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, AppStreamException {
        return createStreamingURL(CreateStreamingUrlRequest.builder().applyMutation(createStreamingUrlRequest).build());
    }

    /**
     * <p>
     * Deletes the specified directory configuration.
     * </p>
     *
     * @param deleteDirectoryConfigRequest
     * @return Result of the DeleteDirectoryConfig operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteDirectoryConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDirectoryConfigResponse deleteDirectoryConfig(DeleteDirectoryConfigRequest deleteDirectoryConfigRequest)
            throws ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified directory configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDirectoryConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDirectoryConfigRequest#builder()}
     * </p>
     *
     * @param deleteDirectoryConfigRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDirectoryConfigRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDirectoryConfig operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteDirectoryConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDirectoryConfigResponse deleteDirectoryConfig(
            Consumer<DeleteDirectoryConfigRequest.Builder> deleteDirectoryConfigRequest) throws ResourceInUseException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        return deleteDirectoryConfig(DeleteDirectoryConfigRequest.builder().applyMutation(deleteDirectoryConfigRequest).build());
    }

    /**
     * <p>
     * Deletes the specified fleet.
     * </p>
     *
     * @param deleteFleetRequest
     * @return Result of the DeleteFleet operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFleetResponse deleteFleet(DeleteFleetRequest deleteFleetRequest) throws ResourceInUseException,
            ResourceNotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFleetRequest#builder()}
     * </p>
     *
     * @param deleteFleetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFleetRequest.Builder} to create a request.
     * @return Result of the DeleteFleet operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFleetResponse deleteFleet(Consumer<DeleteFleetRequest.Builder> deleteFleetRequest)
            throws ResourceInUseException, ResourceNotFoundException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AppStreamException {
        return deleteFleet(DeleteFleetRequest.builder().applyMutation(deleteFleetRequest).build());
    }

    /**
     * Invokes the DeleteImage operation.
     *
     * @param deleteImageRequest
     * @return Result of the DeleteImage operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteImageResponse deleteImage(DeleteImageRequest deleteImageRequest) throws ResourceInUseException,
            ResourceNotFoundException, OperationNotPermittedException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the DeleteImage operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImageRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteImageRequest#builder()}
     * </p>
     *
     * @param deleteImageRequest
     *        A {@link Consumer} that will call methods on {@link DeleteImageRequest.Builder} to create a request.
     * @return Result of the DeleteImage operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteImageResponse deleteImage(Consumer<DeleteImageRequest.Builder> deleteImageRequest)
            throws ResourceInUseException, ResourceNotFoundException, OperationNotPermittedException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        return deleteImage(DeleteImageRequest.builder().applyMutation(deleteImageRequest).build());
    }

    /**
     * Invokes the DeleteImageBuilder operation.
     *
     * @param deleteImageBuilderRequest
     * @return Result of the DeleteImageBuilder operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteImageBuilder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteImageBuilderResponse deleteImageBuilder(DeleteImageBuilderRequest deleteImageBuilderRequest)
            throws ResourceNotFoundException, OperationNotPermittedException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the DeleteImageBuilder operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImageBuilderRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteImageBuilderRequest#builder()}
     * </p>
     *
     * @param deleteImageBuilderRequest
     *        A {@link Consumer} that will call methods on {@link DeleteImageBuilderRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteImageBuilder operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteImageBuilder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteImageBuilderResponse deleteImageBuilder(Consumer<DeleteImageBuilderRequest.Builder> deleteImageBuilderRequest)
            throws ResourceNotFoundException, OperationNotPermittedException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppStreamException {
        return deleteImageBuilder(DeleteImageBuilderRequest.builder().applyMutation(deleteImageBuilderRequest).build());
    }

    /**
     * <p>
     * Deletes the specified stack. After this operation completes, the environment can no longer be activated and any
     * reservations made for the stack are released.
     * </p>
     *
     * @param deleteStackRequest
     * @return Result of the DeleteStack operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteStack" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteStackResponse deleteStack(DeleteStackRequest deleteStackRequest) throws ResourceInUseException,
            ResourceNotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified stack. After this operation completes, the environment can no longer be activated and any
     * reservations made for the stack are released.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStackRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStackRequest#builder()}
     * </p>
     *
     * @param deleteStackRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStackRequest.Builder} to create a request.
     * @return Result of the DeleteStack operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteStack" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteStackResponse deleteStack(Consumer<DeleteStackRequest.Builder> deleteStackRequest)
            throws ResourceInUseException, ResourceNotFoundException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AppStreamException {
        return deleteStack(DeleteStackRequest.builder().applyMutation(deleteStackRequest).build());
    }

    /**
     * <p>
     * Describes the specified directory configurations.
     * </p>
     *
     * @return Result of the DescribeDirectoryConfigs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeDirectoryConfigs
     * @see #describeDirectoryConfigs(DescribeDirectoryConfigsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeDirectoryConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDirectoryConfigsResponse describeDirectoryConfigs() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, AppStreamException {
        return describeDirectoryConfigs(DescribeDirectoryConfigsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified directory configurations.
     * </p>
     *
     * @param describeDirectoryConfigsRequest
     * @return Result of the DescribeDirectoryConfigs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeDirectoryConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeDirectoryConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDirectoryConfigsResponse describeDirectoryConfigs(
            DescribeDirectoryConfigsRequest describeDirectoryConfigsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified directory configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDirectoryConfigsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDirectoryConfigsRequest#builder()}
     * </p>
     *
     * @param describeDirectoryConfigsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDirectoryConfigsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDirectoryConfigs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeDirectoryConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeDirectoryConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDirectoryConfigsResponse describeDirectoryConfigs(
            Consumer<DescribeDirectoryConfigsRequest.Builder> describeDirectoryConfigsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        return describeDirectoryConfigs(DescribeDirectoryConfigsRequest.builder().applyMutation(describeDirectoryConfigsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the specified fleets or all fleets in the account.
     * </p>
     *
     * @return Result of the DescribeFleets operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeFleets
     * @see #describeFleets(DescribeFleetsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFleetsResponse describeFleets() throws ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        return describeFleets(DescribeFleetsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified fleets or all fleets in the account.
     * </p>
     *
     * @param describeFleetsRequest
     * @return Result of the DescribeFleets operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFleetsResponse describeFleets(DescribeFleetsRequest describeFleetsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified fleets or all fleets in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeFleetsRequest#builder()}
     * </p>
     *
     * @param describeFleetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetsRequest.Builder} to create a request.
     * @return Result of the DescribeFleets operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFleetsResponse describeFleets(Consumer<DescribeFleetsRequest.Builder> describeFleetsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        return describeFleets(DescribeFleetsRequest.builder().applyMutation(describeFleetsRequest).build());
    }

    /**
     * Invokes the DescribeImageBuilders operation.
     *
     * @return Result of the DescribeImageBuilders operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImageBuilders
     * @see #describeImageBuilders(DescribeImageBuildersRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImageBuilders"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeImageBuildersResponse describeImageBuilders() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, AppStreamException {
        return describeImageBuilders(DescribeImageBuildersRequest.builder().build());
    }

    /**
     * Invokes the DescribeImageBuilders operation.
     *
     * @param describeImageBuildersRequest
     * @return Result of the DescribeImageBuilders operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImageBuilders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImageBuilders"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeImageBuildersResponse describeImageBuilders(DescribeImageBuildersRequest describeImageBuildersRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the DescribeImageBuilders operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageBuildersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeImageBuildersRequest#builder()}
     * </p>
     *
     * @param describeImageBuildersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImageBuildersRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeImageBuilders operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImageBuilders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImageBuilders"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeImageBuildersResponse describeImageBuilders(
            Consumer<DescribeImageBuildersRequest.Builder> describeImageBuildersRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        return describeImageBuilders(DescribeImageBuildersRequest.builder().applyMutation(describeImageBuildersRequest).build());
    }

    /**
     * <p>
     * Describes the specified images or all images in the account.
     * </p>
     *
     * @return Result of the DescribeImages operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImages
     * @see #describeImages(DescribeImagesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesResponse describeImages() throws ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        return describeImages(DescribeImagesRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified images or all images in the account.
     * </p>
     *
     * @param describeImagesRequest
     * @return Result of the DescribeImages operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesResponse describeImages(DescribeImagesRequest describeImagesRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified images or all images in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImagesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeImagesRequest#builder()}
     * </p>
     *
     * @param describeImagesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImagesRequest.Builder} to create a request.
     * @return Result of the DescribeImages operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesResponse describeImages(Consumer<DescribeImagesRequest.Builder> describeImagesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        return describeImages(DescribeImagesRequest.builder().applyMutation(describeImagesRequest).build());
    }

    /**
     * <p>
     * Describes the streaming sessions for the specified stack and fleet. If a user ID is provided, only the streaming
     * sessions for only that user are returned. If an authentication type is not provided, the default is to
     * authenticate users using a streaming URL.
     * </p>
     *
     * @param describeSessionsRequest
     * @return Result of the DescribeSessions operation returned by the service.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeSessions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSessionsResponse describeSessions(DescribeSessionsRequest describeSessionsRequest)
            throws InvalidParameterCombinationException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the streaming sessions for the specified stack and fleet. If a user ID is provided, only the streaming
     * sessions for only that user are returned. If an authentication type is not provided, the default is to
     * authenticate users using a streaming URL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSessionsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSessionsRequest#builder()}
     * </p>
     *
     * @param describeSessionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSessionsRequest.Builder} to create a request.
     * @return Result of the DescribeSessions operation returned by the service.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeSessions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSessionsResponse describeSessions(Consumer<DescribeSessionsRequest.Builder> describeSessionsRequest)
            throws InvalidParameterCombinationException, AwsServiceException, SdkClientException, AppStreamException {
        return describeSessions(DescribeSessionsRequest.builder().applyMutation(describeSessionsRequest).build());
    }

    /**
     * <p>
     * Describes the specified stacks or all stacks in the account.
     * </p>
     *
     * @return Result of the DescribeStacks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeStacks
     * @see #describeStacks(DescribeStacksRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeStacksResponse describeStacks() throws ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        return describeStacks(DescribeStacksRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified stacks or all stacks in the account.
     * </p>
     *
     * @param describeStacksRequest
     * @return Result of the DescribeStacks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeStacksResponse describeStacks(DescribeStacksRequest describeStacksRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified stacks or all stacks in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStacksRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeStacksRequest#builder()}
     * </p>
     *
     * @param describeStacksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStacksRequest.Builder} to create a request.
     * @return Result of the DescribeStacks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeStacksResponse describeStacks(Consumer<DescribeStacksRequest.Builder> describeStacksRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        return describeStacks(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified fleet from the specified stack.
     * </p>
     *
     * @param disassociateFleetRequest
     * @return Result of the DisassociateFleet operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DisassociateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateFleetResponse disassociateFleet(DisassociateFleetRequest disassociateFleetRequest)
            throws ResourceInUseException, ResourceNotFoundException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified fleet from the specified stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateFleetRequest.Builder} avoiding the need
     * to create one manually via {@link DisassociateFleetRequest#builder()}
     * </p>
     *
     * @param disassociateFleetRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateFleetRequest.Builder} to create a request.
     * @return Result of the DisassociateFleet operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DisassociateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateFleetResponse disassociateFleet(Consumer<DisassociateFleetRequest.Builder> disassociateFleetRequest)
            throws ResourceInUseException, ResourceNotFoundException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AppStreamException {
        return disassociateFleet(DisassociateFleetRequest.builder().applyMutation(disassociateFleetRequest).build());
    }

    /**
     * <p>
     * Stops the specified streaming session.
     * </p>
     *
     * @param expireSessionRequest
     * @return Result of the ExpireSession operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ExpireSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSession" target="_top">AWS API
     *      Documentation</a>
     */
    default ExpireSessionResponse expireSession(ExpireSessionRequest expireSessionRequest) throws AwsServiceException,
            SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified streaming session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExpireSessionRequest.Builder} avoiding the need to
     * create one manually via {@link ExpireSessionRequest#builder()}
     * </p>
     *
     * @param expireSessionRequest
     *        A {@link Consumer} that will call methods on {@link ExpireSessionRequest.Builder} to create a request.
     * @return Result of the ExpireSession operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ExpireSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSession" target="_top">AWS API
     *      Documentation</a>
     */
    default ExpireSessionResponse expireSession(Consumer<ExpireSessionRequest.Builder> expireSessionRequest)
            throws AwsServiceException, SdkClientException, AppStreamException {
        return expireSession(ExpireSessionRequest.builder().applyMutation(expireSessionRequest).build());
    }

    /**
     * <p>
     * Lists the fleets associated with the specified stack.
     * </p>
     *
     * @param listAssociatedFleetsRequest
     * @return Result of the ListAssociatedFleets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ListAssociatedFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssociatedFleetsResponse listAssociatedFleets(ListAssociatedFleetsRequest listAssociatedFleetsRequest)
            throws AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the fleets associated with the specified stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedFleetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssociatedFleetsRequest#builder()}
     * </p>
     *
     * @param listAssociatedFleetsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociatedFleetsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssociatedFleets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ListAssociatedFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssociatedFleetsResponse listAssociatedFleets(
            Consumer<ListAssociatedFleetsRequest.Builder> listAssociatedFleetsRequest) throws AwsServiceException,
            SdkClientException, AppStreamException {
        return listAssociatedFleets(ListAssociatedFleetsRequest.builder().applyMutation(listAssociatedFleetsRequest).build());
    }

    /**
     * <p>
     * Lists the stacks associated with the specified fleet.
     * </p>
     *
     * @param listAssociatedStacksRequest
     * @return Result of the ListAssociatedStacks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ListAssociatedStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssociatedStacksResponse listAssociatedStacks(ListAssociatedStacksRequest listAssociatedStacksRequest)
            throws AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the stacks associated with the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedStacksRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssociatedStacksRequest#builder()}
     * </p>
     *
     * @param listAssociatedStacksRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociatedStacksRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssociatedStacks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ListAssociatedStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssociatedStacksResponse listAssociatedStacks(
            Consumer<ListAssociatedStacksRequest.Builder> listAssociatedStacksRequest) throws AwsServiceException,
            SdkClientException, AppStreamException {
        return listAssociatedStacks(ListAssociatedStacksRequest.builder().applyMutation(listAssociatedStacksRequest).build());
    }

    /**
     * <p>
     * Starts the specified fleet.
     * </p>
     *
     * @param startFleetRequest
     * @return Result of the StartFleet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StartFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default StartFleetResponse startFleet(StartFleetRequest startFleetRequest) throws ResourceNotFoundException,
            OperationNotPermittedException, LimitExceededException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFleetRequest.Builder} avoiding the need to
     * create one manually via {@link StartFleetRequest#builder()}
     * </p>
     *
     * @param startFleetRequest
     *        A {@link Consumer} that will call methods on {@link StartFleetRequest.Builder} to create a request.
     * @return Result of the StartFleet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StartFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default StartFleetResponse startFleet(Consumer<StartFleetRequest.Builder> startFleetRequest)
            throws ResourceNotFoundException, OperationNotPermittedException, LimitExceededException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        return startFleet(StartFleetRequest.builder().applyMutation(startFleetRequest).build());
    }

    /**
     * Invokes the StartImageBuilder operation.
     *
     * @param startImageBuilderRequest
     * @return Result of the StartImageBuilder operation returned by the service.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StartImageBuilder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default StartImageBuilderResponse startImageBuilder(StartImageBuilderRequest startImageBuilderRequest)
            throws ResourceNotAvailableException, ResourceNotFoundException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the StartImageBuilder operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImageBuilderRequest.Builder} avoiding the need
     * to create one manually via {@link StartImageBuilderRequest#builder()}
     * </p>
     *
     * @param startImageBuilderRequest
     *        A {@link Consumer} that will call methods on {@link StartImageBuilderRequest.Builder} to create a request.
     * @return Result of the StartImageBuilder operation returned by the service.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StartImageBuilder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default StartImageBuilderResponse startImageBuilder(Consumer<StartImageBuilderRequest.Builder> startImageBuilderRequest)
            throws ResourceNotAvailableException, ResourceNotFoundException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppStreamException {
        return startImageBuilder(StartImageBuilderRequest.builder().applyMutation(startImageBuilderRequest).build());
    }

    /**
     * <p>
     * Stops the specified fleet.
     * </p>
     *
     * @param stopFleetRequest
     * @return Result of the StopFleet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StopFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default StopFleetResponse stopFleet(StopFleetRequest stopFleetRequest) throws ResourceNotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopFleetRequest.Builder} avoiding the need to
     * create one manually via {@link StopFleetRequest#builder()}
     * </p>
     *
     * @param stopFleetRequest
     *        A {@link Consumer} that will call methods on {@link StopFleetRequest.Builder} to create a request.
     * @return Result of the StopFleet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StopFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default StopFleetResponse stopFleet(Consumer<StopFleetRequest.Builder> stopFleetRequest) throws ResourceNotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        return stopFleet(StopFleetRequest.builder().applyMutation(stopFleetRequest).build());
    }

    /**
     * Invokes the StopImageBuilder operation.
     *
     * @param stopImageBuilderRequest
     * @return Result of the StopImageBuilder operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StopImageBuilder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopImageBuilder" target="_top">AWS API
     *      Documentation</a>
     */
    default StopImageBuilderResponse stopImageBuilder(StopImageBuilderRequest stopImageBuilderRequest)
            throws ResourceNotFoundException, OperationNotPermittedException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the StopImageBuilder operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopImageBuilderRequest.Builder} avoiding the need
     * to create one manually via {@link StopImageBuilderRequest#builder()}
     * </p>
     *
     * @param stopImageBuilderRequest
     *        A {@link Consumer} that will call methods on {@link StopImageBuilderRequest.Builder} to create a request.
     * @return Result of the StopImageBuilder operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StopImageBuilder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopImageBuilder" target="_top">AWS API
     *      Documentation</a>
     */
    default StopImageBuilderResponse stopImageBuilder(Consumer<StopImageBuilderRequest.Builder> stopImageBuilderRequest)
            throws ResourceNotFoundException, OperationNotPermittedException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppStreamException {
        return stopImageBuilder(StopImageBuilderRequest.builder().applyMutation(stopImageBuilderRequest).build());
    }

    /**
     * <p>
     * Updates the specified directory configuration.
     * </p>
     *
     * @param updateDirectoryConfigRequest
     * @return Result of the UpdateDirectoryConfig operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateDirectoryConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDirectoryConfigResponse updateDirectoryConfig(UpdateDirectoryConfigRequest updateDirectoryConfigRequest)
            throws ResourceInUseException, ResourceNotFoundException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified directory configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDirectoryConfigRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDirectoryConfigRequest#builder()}
     * </p>
     *
     * @param updateDirectoryConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDirectoryConfigRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDirectoryConfig operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateDirectoryConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDirectoryConfigResponse updateDirectoryConfig(
            Consumer<UpdateDirectoryConfigRequest.Builder> updateDirectoryConfigRequest) throws ResourceInUseException,
            ResourceNotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AppStreamException {
        return updateDirectoryConfig(UpdateDirectoryConfigRequest.builder().applyMutation(updateDirectoryConfigRequest).build());
    }

    /**
     * <p>
     * Updates the specified fleet.
     * </p>
     * <p>
     * If the fleet is in the <code>STOPPED</code> state, you can update any attribute except the fleet name. If the
     * fleet is in the <code>RUNNING</code> state, you can update the <code>DisplayName</code> and
     * <code>ComputeCapacity</code> attributes. If the fleet is in the <code>STARTING</code> or <code>STOPPING</code>
     * state, you can't update it.
     * </p>
     *
     * @param updateFleetRequest
     * @return Result of the UpdateFleet operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws IncompatibleImageException
     *         The image does not support storage connectors.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFleetResponse updateFleet(UpdateFleetRequest updateFleetRequest) throws ResourceInUseException,
            LimitExceededException, InvalidRoleException, ResourceNotFoundException, ResourceNotAvailableException,
            InvalidParameterCombinationException, ConcurrentModificationException, IncompatibleImageException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified fleet.
     * </p>
     * <p>
     * If the fleet is in the <code>STOPPED</code> state, you can update any attribute except the fleet name. If the
     * fleet is in the <code>RUNNING</code> state, you can update the <code>DisplayName</code> and
     * <code>ComputeCapacity</code> attributes. If the fleet is in the <code>STARTING</code> or <code>STOPPING</code>
     * state, you can't update it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFleetRequest#builder()}
     * </p>
     *
     * @param updateFleetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFleetRequest.Builder} to create a request.
     * @return Result of the UpdateFleet operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws IncompatibleImageException
     *         The image does not support storage connectors.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFleetResponse updateFleet(Consumer<UpdateFleetRequest.Builder> updateFleetRequest)
            throws ResourceInUseException, LimitExceededException, InvalidRoleException, ResourceNotFoundException,
            ResourceNotAvailableException, InvalidParameterCombinationException, ConcurrentModificationException,
            IncompatibleImageException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            AppStreamException {
        return updateFleet(UpdateFleetRequest.builder().applyMutation(updateFleetRequest).build());
    }

    /**
     * <p>
     * Updates the specified stack.
     * </p>
     *
     * @param updateStackRequest
     * @return Result of the UpdateStack operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws IncompatibleImageException
     *         The image does not support storage connectors.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateStackResponse updateStack(UpdateStackRequest updateStackRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidRoleException, InvalidParameterCombinationException, LimitExceededException,
            IncompatibleImageException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStackRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStackRequest#builder()}
     * </p>
     *
     * @param updateStackRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStackRequest.Builder} to create a request.
     * @return Result of the UpdateStack operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws IncompatibleImageException
     *         The image does not support storage connectors.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateStackResponse updateStack(Consumer<UpdateStackRequest.Builder> updateStackRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidRoleException, InvalidParameterCombinationException,
            LimitExceededException, IncompatibleImageException, AwsServiceException, SdkClientException, AppStreamException {
        return updateStack(UpdateStackRequest.builder().applyMutation(updateStackRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("appstream2");
    }
}
