/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.appstream.model.AssociateFleetRequest;
import software.amazon.awssdk.services.appstream.model.AssociateFleetResponse;
import software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigRequest;
import software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigResponse;
import software.amazon.awssdk.services.appstream.model.CreateFleetRequest;
import software.amazon.awssdk.services.appstream.model.CreateFleetResponse;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderRequest;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderResponse;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderStreamingUrlRequest;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderStreamingUrlResponse;
import software.amazon.awssdk.services.appstream.model.CreateStackRequest;
import software.amazon.awssdk.services.appstream.model.CreateStackResponse;
import software.amazon.awssdk.services.appstream.model.CreateStreamingUrlRequest;
import software.amazon.awssdk.services.appstream.model.CreateStreamingUrlResponse;
import software.amazon.awssdk.services.appstream.model.DeleteDirectoryConfigRequest;
import software.amazon.awssdk.services.appstream.model.DeleteDirectoryConfigResponse;
import software.amazon.awssdk.services.appstream.model.DeleteFleetRequest;
import software.amazon.awssdk.services.appstream.model.DeleteFleetResponse;
import software.amazon.awssdk.services.appstream.model.DeleteImageBuilderRequest;
import software.amazon.awssdk.services.appstream.model.DeleteImageBuilderResponse;
import software.amazon.awssdk.services.appstream.model.DeleteImageRequest;
import software.amazon.awssdk.services.appstream.model.DeleteImageResponse;
import software.amazon.awssdk.services.appstream.model.DeleteStackRequest;
import software.amazon.awssdk.services.appstream.model.DeleteStackResponse;
import software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeImageBuildersRequest;
import software.amazon.awssdk.services.appstream.model.DescribeImageBuildersResponse;
import software.amazon.awssdk.services.appstream.model.DescribeImagesRequest;
import software.amazon.awssdk.services.appstream.model.DescribeImagesResponse;
import software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeSessionsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeStacksRequest;
import software.amazon.awssdk.services.appstream.model.DescribeStacksResponse;
import software.amazon.awssdk.services.appstream.model.DisassociateFleetRequest;
import software.amazon.awssdk.services.appstream.model.DisassociateFleetResponse;
import software.amazon.awssdk.services.appstream.model.ExpireSessionRequest;
import software.amazon.awssdk.services.appstream.model.ExpireSessionResponse;
import software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsRequest;
import software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsResponse;
import software.amazon.awssdk.services.appstream.model.ListAssociatedStacksRequest;
import software.amazon.awssdk.services.appstream.model.ListAssociatedStacksResponse;
import software.amazon.awssdk.services.appstream.model.StartFleetRequest;
import software.amazon.awssdk.services.appstream.model.StartFleetResponse;
import software.amazon.awssdk.services.appstream.model.StartImageBuilderRequest;
import software.amazon.awssdk.services.appstream.model.StartImageBuilderResponse;
import software.amazon.awssdk.services.appstream.model.StopFleetRequest;
import software.amazon.awssdk.services.appstream.model.StopFleetResponse;
import software.amazon.awssdk.services.appstream.model.StopImageBuilderRequest;
import software.amazon.awssdk.services.appstream.model.StopImageBuilderResponse;
import software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigRequest;
import software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigResponse;
import software.amazon.awssdk.services.appstream.model.UpdateFleetRequest;
import software.amazon.awssdk.services.appstream.model.UpdateFleetResponse;
import software.amazon.awssdk.services.appstream.model.UpdateStackRequest;
import software.amazon.awssdk.services.appstream.model.UpdateStackResponse;

/**
 * Service client for accessing null asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon AppStream 2.0</fullname>
 * <p>
 * You can use Amazon AppStream 2.0 to stream desktop applications to any device running a web browser, without
 * rewriting them.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface AppStreamAsyncClient extends SdkClient {
    String SERVICE_NAME = "appstream";

    /**
     * Create a {@link AppStreamAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AppStreamAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AppStreamAsyncClient}.
     */
    static AppStreamAsyncClientBuilder builder() {
        return new DefaultAppStreamAsyncClientBuilder();
    }

    /**
     * <p>
     * Associates the specified fleet with the specified stack.
     * </p>
     *
     * @param associateFleetRequest
     * @return A Java Future containing the result of the AssociateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>IncompatibleImageException The image does not support storage connectors.</li>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.AssociateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateFleetResponse> associateFleet(AssociateFleetRequest associateFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified fleet with the specified stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link AssociateFleetRequest#builder()}
     * </p>
     *
     * @param associateFleetRequest
     *        A {@link Consumer} that will call methods on {@link AssociateFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>IncompatibleImageException The image does not support storage connectors.</li>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.AssociateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateFleetResponse> associateFleet(Consumer<AssociateFleetRequest.Builder> associateFleetRequest) {
        return associateFleet(AssociateFleetRequest.builder().applyMutation(associateFleetRequest).build());
    }

    /**
     * <p>
     * Creates a directory configuration.
     * </p>
     *
     * @param createDirectoryConfigRequest
     * @return A Java Future containing the result of the CreateDirectoryConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.CreateDirectoryConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDirectoryConfigResponse> createDirectoryConfig(
            CreateDirectoryConfigRequest createDirectoryConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a directory configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDirectoryConfigRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDirectoryConfigRequest#builder()}
     * </p>
     *
     * @param createDirectoryConfigRequest
     *        A {@link Consumer} that will call methods on {@link CreateDirectoryConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDirectoryConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.CreateDirectoryConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDirectoryConfigResponse> createDirectoryConfig(
            Consumer<CreateDirectoryConfigRequest.Builder> createDirectoryConfigRequest) {
        return createDirectoryConfig(CreateDirectoryConfigRequest.builder().applyMutation(createDirectoryConfigRequest).build());
    }

    /**
     * <p>
     * Creates a fleet.
     * </p>
     *
     * @param createFleetRequest
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotAvailableException The specified resource exists and is not in use, but isn't available.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>InvalidRoleException The specified role is invalid.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>IncompatibleImageException The image does not support storage connectors.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.CreateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFleetResponse> createFleet(CreateFleetRequest createFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFleetRequest#builder()}
     * </p>
     *
     * @param createFleetRequest
     *        A {@link Consumer} that will call methods on {@link CreateFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotAvailableException The specified resource exists and is not in use, but isn't available.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>InvalidRoleException The specified role is invalid.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>IncompatibleImageException The image does not support storage connectors.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.CreateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFleetResponse> createFleet(Consumer<CreateFleetRequest.Builder> createFleetRequest) {
        return createFleet(CreateFleetRequest.builder().applyMutation(createFleetRequest).build());
    }

    /**
     * Invokes the CreateImageBuilder operation asynchronously.
     *
     * @param createImageBuilderRequest
     * @return A Java Future containing the result of the CreateImageBuilder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotAvailableException The specified resource exists and is not in use, but isn't available.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRoleException The specified role is invalid.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>IncompatibleImageException The image does not support storage connectors.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.CreateImageBuilder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateImageBuilderResponse> createImageBuilder(CreateImageBuilderRequest createImageBuilderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the CreateImageBuilder operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImageBuilderRequest.Builder} avoiding the
     * need to create one manually via {@link CreateImageBuilderRequest#builder()}
     * </p>
     *
     * @param createImageBuilderRequest
     *        A {@link Consumer} that will call methods on {@link CreateImageBuilderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateImageBuilder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotAvailableException The specified resource exists and is not in use, but isn't available.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRoleException The specified role is invalid.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>IncompatibleImageException The image does not support storage connectors.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.CreateImageBuilder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateImageBuilderResponse> createImageBuilder(
            Consumer<CreateImageBuilderRequest.Builder> createImageBuilderRequest) {
        return createImageBuilder(CreateImageBuilderRequest.builder().applyMutation(createImageBuilderRequest).build());
    }

    /**
     * Invokes the CreateImageBuilderStreamingURL operation asynchronously.
     *
     * @param createImageBuilderStreamingUrlRequest
     * @return A Java Future containing the result of the CreateImageBuilderStreamingURL operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.CreateImageBuilderStreamingURL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilderStreamingURL"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateImageBuilderStreamingUrlResponse> createImageBuilderStreamingURL(
            CreateImageBuilderStreamingUrlRequest createImageBuilderStreamingUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the CreateImageBuilderStreamingURL operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImageBuilderStreamingUrlRequest.Builder}
     * avoiding the need to create one manually via {@link CreateImageBuilderStreamingUrlRequest#builder()}
     * </p>
     *
     * @param createImageBuilderStreamingUrlRequest
     *        A {@link Consumer} that will call methods on {@link CreateImageBuilderStreamingURLRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateImageBuilderStreamingURL operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.CreateImageBuilderStreamingURL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilderStreamingURL"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateImageBuilderStreamingUrlResponse> createImageBuilderStreamingURL(
            Consumer<CreateImageBuilderStreamingUrlRequest.Builder> createImageBuilderStreamingUrlRequest) {
        return createImageBuilderStreamingURL(CreateImageBuilderStreamingUrlRequest.builder()
                .applyMutation(createImageBuilderStreamingUrlRequest).build());
    }

    /**
     * <p>
     * Creates a stack.
     * </p>
     *
     * @param createStackRequest
     * @return A Java Future containing the result of the CreateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>InvalidRoleException The specified role is invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.CreateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateStackResponse> createStack(CreateStackRequest createStackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStackRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStackRequest#builder()}
     * </p>
     *
     * @param createStackRequest
     *        A {@link Consumer} that will call methods on {@link CreateStackRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>InvalidRoleException The specified role is invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.CreateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateStackResponse> createStack(Consumer<CreateStackRequest.Builder> createStackRequest) {
        return createStack(CreateStackRequest.builder().applyMutation(createStackRequest).build());
    }

    /**
     * <p>
     * Creates a URL to start a streaming session for the specified user.
     * </p>
     * <p>
     * By default, the URL is valid only for one minute from the time that it is generated.
     * </p>
     *
     * @param createStreamingUrlRequest
     * @return A Java Future containing the result of the CreateStreamingURL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceNotAvailableException The specified resource exists and is not in use, but isn't available.</li>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.CreateStreamingURL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStreamingURL" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStreamingUrlResponse> createStreamingURL(CreateStreamingUrlRequest createStreamingUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a URL to start a streaming session for the specified user.
     * </p>
     * <p>
     * By default, the URL is valid only for one minute from the time that it is generated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamingUrlRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStreamingUrlRequest#builder()}
     * </p>
     *
     * @param createStreamingUrlRequest
     *        A {@link Consumer} that will call methods on {@link CreateStreamingURLRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateStreamingURL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceNotAvailableException The specified resource exists and is not in use, but isn't available.</li>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.CreateStreamingURL
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStreamingURL" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStreamingUrlResponse> createStreamingURL(
            Consumer<CreateStreamingUrlRequest.Builder> createStreamingUrlRequest) {
        return createStreamingURL(CreateStreamingUrlRequest.builder().applyMutation(createStreamingUrlRequest).build());
    }

    /**
     * <p>
     * Deletes the specified directory configuration.
     * </p>
     *
     * @param deleteDirectoryConfigRequest
     * @return A Java Future containing the result of the DeleteDirectoryConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DeleteDirectoryConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDirectoryConfigResponse> deleteDirectoryConfig(
            DeleteDirectoryConfigRequest deleteDirectoryConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified directory configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDirectoryConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDirectoryConfigRequest#builder()}
     * </p>
     *
     * @param deleteDirectoryConfigRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDirectoryConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDirectoryConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DeleteDirectoryConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDirectoryConfigResponse> deleteDirectoryConfig(
            Consumer<DeleteDirectoryConfigRequest.Builder> deleteDirectoryConfigRequest) {
        return deleteDirectoryConfig(DeleteDirectoryConfigRequest.builder().applyMutation(deleteDirectoryConfigRequest).build());
    }

    /**
     * <p>
     * Deletes the specified fleet.
     * </p>
     *
     * @param deleteFleetRequest
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DeleteFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFleetResponse> deleteFleet(DeleteFleetRequest deleteFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFleetRequest#builder()}
     * </p>
     *
     * @param deleteFleetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DeleteFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFleetResponse> deleteFleet(Consumer<DeleteFleetRequest.Builder> deleteFleetRequest) {
        return deleteFleet(DeleteFleetRequest.builder().applyMutation(deleteFleetRequest).build());
    }

    /**
     * Invokes the DeleteImage operation asynchronously.
     *
     * @param deleteImageRequest
     * @return A Java Future containing the result of the DeleteImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DeleteImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteImageResponse> deleteImage(DeleteImageRequest deleteImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the DeleteImage operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImageRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteImageRequest#builder()}
     * </p>
     *
     * @param deleteImageRequest
     *        A {@link Consumer} that will call methods on {@link DeleteImageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DeleteImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteImageResponse> deleteImage(Consumer<DeleteImageRequest.Builder> deleteImageRequest) {
        return deleteImage(DeleteImageRequest.builder().applyMutation(deleteImageRequest).build());
    }

    /**
     * Invokes the DeleteImageBuilder operation asynchronously.
     *
     * @param deleteImageBuilderRequest
     * @return A Java Future containing the result of the DeleteImageBuilder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DeleteImageBuilder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteImageBuilderResponse> deleteImageBuilder(DeleteImageBuilderRequest deleteImageBuilderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the DeleteImageBuilder operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImageBuilderRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteImageBuilderRequest#builder()}
     * </p>
     *
     * @param deleteImageBuilderRequest
     *        A {@link Consumer} that will call methods on {@link DeleteImageBuilderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteImageBuilder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DeleteImageBuilder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteImageBuilderResponse> deleteImageBuilder(
            Consumer<DeleteImageBuilderRequest.Builder> deleteImageBuilderRequest) {
        return deleteImageBuilder(DeleteImageBuilderRequest.builder().applyMutation(deleteImageBuilderRequest).build());
    }

    /**
     * <p>
     * Deletes the specified stack. After this operation completes, the environment can no longer be activated and any
     * reservations made for the stack are released.
     * </p>
     *
     * @param deleteStackRequest
     * @return A Java Future containing the result of the DeleteStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DeleteStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStackResponse> deleteStack(DeleteStackRequest deleteStackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified stack. After this operation completes, the environment can no longer be activated and any
     * reservations made for the stack are released.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStackRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStackRequest#builder()}
     * </p>
     *
     * @param deleteStackRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStackRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DeleteStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStackResponse> deleteStack(Consumer<DeleteStackRequest.Builder> deleteStackRequest) {
        return deleteStack(DeleteStackRequest.builder().applyMutation(deleteStackRequest).build());
    }

    /**
     * <p>
     * Describes the specified directory configurations.
     * </p>
     *
     * @param describeDirectoryConfigsRequest
     * @return A Java Future containing the result of the DescribeDirectoryConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeDirectoryConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeDirectoryConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDirectoryConfigsResponse> describeDirectoryConfigs(
            DescribeDirectoryConfigsRequest describeDirectoryConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified directory configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDirectoryConfigsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDirectoryConfigsRequest#builder()}
     * </p>
     *
     * @param describeDirectoryConfigsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDirectoryConfigsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDirectoryConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeDirectoryConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeDirectoryConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDirectoryConfigsResponse> describeDirectoryConfigs(
            Consumer<DescribeDirectoryConfigsRequest.Builder> describeDirectoryConfigsRequest) {
        return describeDirectoryConfigs(DescribeDirectoryConfigsRequest.builder().applyMutation(describeDirectoryConfigsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the specified directory configurations.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDirectoryConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeDirectoryConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeDirectoryConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDirectoryConfigsResponse> describeDirectoryConfigs() {
        return describeDirectoryConfigs(DescribeDirectoryConfigsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified fleets or all fleets in the account.
     * </p>
     *
     * @param describeFleetsRequest
     * @return A Java Future containing the result of the DescribeFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFleetsResponse> describeFleets(DescribeFleetsRequest describeFleetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified fleets or all fleets in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeFleetsRequest#builder()}
     * </p>
     *
     * @param describeFleetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFleetsResponse> describeFleets(Consumer<DescribeFleetsRequest.Builder> describeFleetsRequest) {
        return describeFleets(DescribeFleetsRequest.builder().applyMutation(describeFleetsRequest).build());
    }

    /**
     * <p>
     * Describes the specified fleets or all fleets in the account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFleetsResponse> describeFleets() {
        return describeFleets(DescribeFleetsRequest.builder().build());
    }

    /**
     * Invokes the DescribeImageBuilders operation asynchronously.
     *
     * @param describeImageBuildersRequest
     * @return A Java Future containing the result of the DescribeImageBuilders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeImageBuilders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImageBuilders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeImageBuildersResponse> describeImageBuilders(
            DescribeImageBuildersRequest describeImageBuildersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the DescribeImageBuilders operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageBuildersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeImageBuildersRequest#builder()}
     * </p>
     *
     * @param describeImageBuildersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImageBuildersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeImageBuilders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeImageBuilders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImageBuilders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeImageBuildersResponse> describeImageBuilders(
            Consumer<DescribeImageBuildersRequest.Builder> describeImageBuildersRequest) {
        return describeImageBuilders(DescribeImageBuildersRequest.builder().applyMutation(describeImageBuildersRequest).build());
    }

    /**
     * Invokes the DescribeImageBuilders operation asynchronously.
     *
     * @return A Java Future containing the result of the DescribeImageBuilders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeImageBuilders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImageBuilders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeImageBuildersResponse> describeImageBuilders() {
        return describeImageBuilders(DescribeImageBuildersRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified images or all images in the account.
     * </p>
     *
     * @param describeImagesRequest
     * @return A Java Future containing the result of the DescribeImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeImagesResponse> describeImages(DescribeImagesRequest describeImagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified images or all images in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImagesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeImagesRequest#builder()}
     * </p>
     *
     * @param describeImagesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImagesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeImagesResponse> describeImages(Consumer<DescribeImagesRequest.Builder> describeImagesRequest) {
        return describeImages(DescribeImagesRequest.builder().applyMutation(describeImagesRequest).build());
    }

    /**
     * <p>
     * Describes the specified images or all images in the account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeImagesResponse> describeImages() {
        return describeImages(DescribeImagesRequest.builder().build());
    }

    /**
     * <p>
     * Describes the streaming sessions for the specified stack and fleet. If a user ID is provided, only the streaming
     * sessions for only that user are returned. If an authentication type is not provided, the default is to
     * authenticate users using a streaming URL.
     * </p>
     *
     * @param describeSessionsRequest
     * @return A Java Future containing the result of the DescribeSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeSessions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSessionsResponse> describeSessions(DescribeSessionsRequest describeSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the streaming sessions for the specified stack and fleet. If a user ID is provided, only the streaming
     * sessions for only that user are returned. If an authentication type is not provided, the default is to
     * authenticate users using a streaming URL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSessionsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSessionsRequest#builder()}
     * </p>
     *
     * @param describeSessionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSessionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeSessions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSessionsResponse> describeSessions(
            Consumer<DescribeSessionsRequest.Builder> describeSessionsRequest) {
        return describeSessions(DescribeSessionsRequest.builder().applyMutation(describeSessionsRequest).build());
    }

    /**
     * <p>
     * Describes the specified stacks or all stacks in the account.
     * </p>
     *
     * @param describeStacksRequest
     * @return A Java Future containing the result of the DescribeStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeStacksResponse> describeStacks(DescribeStacksRequest describeStacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified stacks or all stacks in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStacksRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeStacksRequest#builder()}
     * </p>
     *
     * @param describeStacksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStacksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeStacksResponse> describeStacks(Consumer<DescribeStacksRequest.Builder> describeStacksRequest) {
        return describeStacks(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build());
    }

    /**
     * <p>
     * Describes the specified stacks or all stacks in the account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeStacksResponse> describeStacks() {
        return describeStacks(DescribeStacksRequest.builder().build());
    }

    /**
     * <p>
     * Disassociates the specified fleet from the specified stack.
     * </p>
     *
     * @param disassociateFleetRequest
     * @return A Java Future containing the result of the DisassociateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DisassociateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateFleetResponse> disassociateFleet(DisassociateFleetRequest disassociateFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified fleet from the specified stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateFleetRequest.Builder} avoiding the need
     * to create one manually via {@link DisassociateFleetRequest#builder()}
     * </p>
     *
     * @param disassociateFleetRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.DisassociateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateFleetResponse> disassociateFleet(
            Consumer<DisassociateFleetRequest.Builder> disassociateFleetRequest) {
        return disassociateFleet(DisassociateFleetRequest.builder().applyMutation(disassociateFleetRequest).build());
    }

    /**
     * <p>
     * Stops the specified streaming session.
     * </p>
     *
     * @param expireSessionRequest
     * @return A Java Future containing the result of the ExpireSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.ExpireSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExpireSessionResponse> expireSession(ExpireSessionRequest expireSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified streaming session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExpireSessionRequest.Builder} avoiding the need to
     * create one manually via {@link ExpireSessionRequest#builder()}
     * </p>
     *
     * @param expireSessionRequest
     *        A {@link Consumer} that will call methods on {@link ExpireSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ExpireSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.ExpireSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExpireSessionResponse> expireSession(Consumer<ExpireSessionRequest.Builder> expireSessionRequest) {
        return expireSession(ExpireSessionRequest.builder().applyMutation(expireSessionRequest).build());
    }

    /**
     * <p>
     * Lists the fleets associated with the specified stack.
     * </p>
     *
     * @param listAssociatedFleetsRequest
     * @return A Java Future containing the result of the ListAssociatedFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.ListAssociatedFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssociatedFleetsResponse> listAssociatedFleets(
            ListAssociatedFleetsRequest listAssociatedFleetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the fleets associated with the specified stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedFleetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssociatedFleetsRequest#builder()}
     * </p>
     *
     * @param listAssociatedFleetsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociatedFleetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAssociatedFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.ListAssociatedFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssociatedFleetsResponse> listAssociatedFleets(
            Consumer<ListAssociatedFleetsRequest.Builder> listAssociatedFleetsRequest) {
        return listAssociatedFleets(ListAssociatedFleetsRequest.builder().applyMutation(listAssociatedFleetsRequest).build());
    }

    /**
     * <p>
     * Lists the stacks associated with the specified fleet.
     * </p>
     *
     * @param listAssociatedStacksRequest
     * @return A Java Future containing the result of the ListAssociatedStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.ListAssociatedStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssociatedStacksResponse> listAssociatedStacks(
            ListAssociatedStacksRequest listAssociatedStacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the stacks associated with the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedStacksRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssociatedStacksRequest#builder()}
     * </p>
     *
     * @param listAssociatedStacksRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociatedStacksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAssociatedStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.ListAssociatedStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssociatedStacksResponse> listAssociatedStacks(
            Consumer<ListAssociatedStacksRequest.Builder> listAssociatedStacksRequest) {
        return listAssociatedStacks(ListAssociatedStacksRequest.builder().applyMutation(listAssociatedStacksRequest).build());
    }

    /**
     * <p>
     * Starts the specified fleet.
     * </p>
     *
     * @param startFleetRequest
     * @return A Java Future containing the result of the StartFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.StartFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartFleetResponse> startFleet(StartFleetRequest startFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFleetRequest.Builder} avoiding the need to
     * create one manually via {@link StartFleetRequest#builder()}
     * </p>
     *
     * @param startFleetRequest
     *        A {@link Consumer} that will call methods on {@link StartFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.StartFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartFleetResponse> startFleet(Consumer<StartFleetRequest.Builder> startFleetRequest) {
        return startFleet(StartFleetRequest.builder().applyMutation(startFleetRequest).build());
    }

    /**
     * Invokes the StartImageBuilder operation asynchronously.
     *
     * @param startImageBuilderRequest
     * @return A Java Future containing the result of the StartImageBuilder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotAvailableException The specified resource exists and is not in use, but isn't available.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.StartImageBuilder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartImageBuilderResponse> startImageBuilder(StartImageBuilderRequest startImageBuilderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the StartImageBuilder operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImageBuilderRequest.Builder} avoiding the need
     * to create one manually via {@link StartImageBuilderRequest#builder()}
     * </p>
     *
     * @param startImageBuilderRequest
     *        A {@link Consumer} that will call methods on {@link StartImageBuilderRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartImageBuilder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotAvailableException The specified resource exists and is not in use, but isn't available.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.StartImageBuilder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartImageBuilderResponse> startImageBuilder(
            Consumer<StartImageBuilderRequest.Builder> startImageBuilderRequest) {
        return startImageBuilder(StartImageBuilderRequest.builder().applyMutation(startImageBuilderRequest).build());
    }

    /**
     * <p>
     * Stops the specified fleet.
     * </p>
     *
     * @param stopFleetRequest
     * @return A Java Future containing the result of the StopFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.StopFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopFleetResponse> stopFleet(StopFleetRequest stopFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopFleetRequest.Builder} avoiding the need to
     * create one manually via {@link StopFleetRequest#builder()}
     * </p>
     *
     * @param stopFleetRequest
     *        A {@link Consumer} that will call methods on {@link StopFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.StopFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopFleetResponse> stopFleet(Consumer<StopFleetRequest.Builder> stopFleetRequest) {
        return stopFleet(StopFleetRequest.builder().applyMutation(stopFleetRequest).build());
    }

    /**
     * Invokes the StopImageBuilder operation asynchronously.
     *
     * @param stopImageBuilderRequest
     * @return A Java Future containing the result of the StopImageBuilder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.StopImageBuilder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopImageBuilder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopImageBuilderResponse> stopImageBuilder(StopImageBuilderRequest stopImageBuilderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the StopImageBuilder operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopImageBuilderRequest.Builder} avoiding the need
     * to create one manually via {@link StopImageBuilderRequest#builder()}
     * </p>
     *
     * @param stopImageBuilderRequest
     *        A {@link Consumer} that will call methods on {@link StopImageBuilderRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopImageBuilder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.StopImageBuilder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopImageBuilder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopImageBuilderResponse> stopImageBuilder(
            Consumer<StopImageBuilderRequest.Builder> stopImageBuilderRequest) {
        return stopImageBuilder(StopImageBuilderRequest.builder().applyMutation(stopImageBuilderRequest).build());
    }

    /**
     * <p>
     * Updates the specified directory configuration.
     * </p>
     *
     * @param updateDirectoryConfigRequest
     * @return A Java Future containing the result of the UpdateDirectoryConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.UpdateDirectoryConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDirectoryConfigResponse> updateDirectoryConfig(
            UpdateDirectoryConfigRequest updateDirectoryConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified directory configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDirectoryConfigRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDirectoryConfigRequest#builder()}
     * </p>
     *
     * @param updateDirectoryConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDirectoryConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDirectoryConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.UpdateDirectoryConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDirectoryConfigResponse> updateDirectoryConfig(
            Consumer<UpdateDirectoryConfigRequest.Builder> updateDirectoryConfigRequest) {
        return updateDirectoryConfig(UpdateDirectoryConfigRequest.builder().applyMutation(updateDirectoryConfigRequest).build());
    }

    /**
     * <p>
     * Updates the specified fleet.
     * </p>
     * <p>
     * If the fleet is in the <code>STOPPED</code> state, you can update any attribute except the fleet name. If the
     * fleet is in the <code>RUNNING</code> state, you can update the <code>DisplayName</code> and
     * <code>ComputeCapacity</code> attributes. If the fleet is in the <code>STARTING</code> or <code>STOPPING</code>
     * state, you can't update it.
     * </p>
     *
     * @param updateFleetRequest
     * @return A Java Future containing the result of the UpdateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>InvalidRoleException The specified role is invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceNotAvailableException The specified resource exists and is not in use, but isn't available.</li>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>IncompatibleImageException The image does not support storage connectors.</li>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.UpdateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFleetResponse> updateFleet(UpdateFleetRequest updateFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified fleet.
     * </p>
     * <p>
     * If the fleet is in the <code>STOPPED</code> state, you can update any attribute except the fleet name. If the
     * fleet is in the <code>RUNNING</code> state, you can update the <code>DisplayName</code> and
     * <code>ComputeCapacity</code> attributes. If the fleet is in the <code>STARTING</code> or <code>STOPPING</code>
     * state, you can't update it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFleetRequest#builder()}
     * </p>
     *
     * @param updateFleetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>InvalidRoleException The specified role is invalid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceNotAvailableException The specified resource exists and is not in use, but isn't available.</li>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>ConcurrentModificationException An API error occurred. Wait a few minutes and try again.</li>
     *         <li>IncompatibleImageException The image does not support storage connectors.</li>
     *         <li>OperationNotPermittedException The attempted operation is not permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.UpdateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFleetResponse> updateFleet(Consumer<UpdateFleetRequest.Builder> updateFleetRequest) {
        return updateFleet(UpdateFleetRequest.builder().applyMutation(updateFleetRequest).build());
    }

    /**
     * <p>
     * Updates the specified stack.
     * </p>
     *
     * @param updateStackRequest
     * @return A Java Future containing the result of the UpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>InvalidRoleException The specified role is invalid.</li>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>IncompatibleImageException The image does not support storage connectors.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.UpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStackResponse> updateStack(UpdateStackRequest updateStackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStackRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStackRequest#builder()}
     * </p>
     *
     * @param updateStackRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStackRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>InvalidRoleException The specified role is invalid.</li>
     *         <li>InvalidParameterCombinationException Indicates an incorrect combination of parameters, or a missing
     *         parameter.</li>
     *         <li>LimitExceededException The requested limit exceeds the permitted limit for an account.</li>
     *         <li>IncompatibleImageException The image does not support storage connectors.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppStreamException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppStreamAsyncClient.UpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStackResponse> updateStack(Consumer<UpdateStackRequest.Builder> updateStackRequest) {
        return updateStack(UpdateStackRequest.builder().applyMutation(updateStackRequest).build());
    }
}
