/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.DomainJoinInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DomainJoinInfoMarshaller {
    private static final MarshallingInfo<String> DIRECTORYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DirectoryName").isBinary(false).build();
    private static final MarshallingInfo<String> ORGANIZATIONALUNITDISTINGUISHEDNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrganizationalUnitDistinguishedName").isBinary(false).build();
    private static final DomainJoinInfoMarshaller INSTANCE = new DomainJoinInfoMarshaller();

    private DomainJoinInfoMarshaller() {
    }

    public static DomainJoinInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DomainJoinInfo domainJoinInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)domainJoinInfo, (String)"domainJoinInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)domainJoinInfo.directoryName(), DIRECTORYNAME_BINDING);
            protocolMarshaller.marshall((Object)domainJoinInfo.organizationalUnitDistinguishedName(), ORGANIZATIONALUNITDISTINGUISHEDNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

