/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.CreateStreamingURLRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateStreamingURLRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateStreamingURLRequestModelMarshaller {
    private static final MarshallingInfo<String> STACKNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackName").isBinary(false).build();

    private static final MarshallingInfo<String> FLEETNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetName").isBinary(false).build();

    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserId").isBinary(false).build();

    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationId").isBinary(false).build();

    private static final MarshallingInfo<Long> VALIDITY_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Validity").isBinary(false).build();

    private static final MarshallingInfo<String> SESSIONCONTEXT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SessionContext").isBinary(false).build();

    private static final CreateStreamingURLRequestModelMarshaller INSTANCE = new CreateStreamingURLRequestModelMarshaller();

    private CreateStreamingURLRequestModelMarshaller() {
    }

    public static CreateStreamingURLRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateStreamingURLRequest createStreamingURLRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createStreamingURLRequest, "createStreamingURLRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createStreamingURLRequest.stackName(), STACKNAME_BINDING);
            protocolMarshaller.marshall(createStreamingURLRequest.fleetName(), FLEETNAME_BINDING);
            protocolMarshaller.marshall(createStreamingURLRequest.userId(), USERID_BINDING);
            protocolMarshaller.marshall(createStreamingURLRequest.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall(createStreamingURLRequest.validity(), VALIDITY_BINDING);
            protocolMarshaller.marshall(createStreamingURLRequest.sessionContext(), SESSIONCONTEXT_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
