/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ComputeCapacityStatus} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ComputeCapacityStatusMarshaller {
    private static final MarshallingInfo<Integer> DESIRED_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Desired").isBinary(false).build();

    private static final MarshallingInfo<Integer> RUNNING_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Running").isBinary(false).build();

    private static final MarshallingInfo<Integer> INUSE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InUse").isBinary(false).build();

    private static final MarshallingInfo<Integer> AVAILABLE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Available").isBinary(false).build();

    private static final ComputeCapacityStatusMarshaller INSTANCE = new ComputeCapacityStatusMarshaller();

    private ComputeCapacityStatusMarshaller() {
    }

    public static ComputeCapacityStatusMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ComputeCapacityStatus computeCapacityStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(computeCapacityStatus, "computeCapacityStatus");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(computeCapacityStatus.desired(), DESIRED_BINDING);
            protocolMarshaller.marshall(computeCapacityStatus.running(), RUNNING_BINDING);
            protocolMarshaller.marshall(computeCapacityStatus.inUse(), INUSE_BINDING);
            protocolMarshaller.marshall(computeCapacityStatus.available(), AVAILABLE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
