/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.ServiceAccountCredentialsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the credentials for the service account used by the streaming instance to connect to the directory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ServiceAccountCredentials implements StructuredPojo,
        ToCopyableBuilder<ServiceAccountCredentials.Builder, ServiceAccountCredentials> {
    private final String accountName;

    private final String accountPassword;

    private ServiceAccountCredentials(BuilderImpl builder) {
        this.accountName = builder.accountName;
        this.accountPassword = builder.accountPassword;
    }

    /**
     * <p>
     * The user name of the account. This account must have the following privileges: create computer objects, join
     * computers to the domain, and change/reset the password on descendant computer objects for the organizational
     * units specified.
     * </p>
     * 
     * @return The user name of the account. This account must have the following privileges: create computer objects,
     *         join computers to the domain, and change/reset the password on descendant computer objects for the
     *         organizational units specified.
     */
    public String accountName() {
        return accountName;
    }

    /**
     * <p>
     * The password for the account.
     * </p>
     * 
     * @return The password for the account.
     */
    public String accountPassword() {
        return accountPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountName());
        hashCode = 31 * hashCode + Objects.hashCode(accountPassword());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceAccountCredentials)) {
            return false;
        }
        ServiceAccountCredentials other = (ServiceAccountCredentials) obj;
        return Objects.equals(accountName(), other.accountName()) && Objects.equals(accountPassword(), other.accountPassword());
    }

    @Override
    public String toString() {
        return ToString.builder("ServiceAccountCredentials").add("AccountName", accountName())
                .add("AccountPassword", accountPassword()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountName":
            return Optional.of(clazz.cast(accountName()));
        case "AccountPassword":
            return Optional.of(clazz.cast(accountPassword()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceAccountCredentialsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ServiceAccountCredentials> {
        /**
         * <p>
         * The user name of the account. This account must have the following privileges: create computer objects, join
         * computers to the domain, and change/reset the password on descendant computer objects for the organizational
         * units specified.
         * </p>
         * 
         * @param accountName
         *        The user name of the account. This account must have the following privileges: create computer
         *        objects, join computers to the domain, and change/reset the password on descendant computer objects
         *        for the organizational units specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountName(String accountName);

        /**
         * <p>
         * The password for the account.
         * </p>
         * 
         * @param accountPassword
         *        The password for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountPassword(String accountPassword);
    }

    static final class BuilderImpl implements Builder {
        private String accountName;

        private String accountPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceAccountCredentials model) {
            accountName(model.accountName);
            accountPassword(model.accountPassword);
        }

        public final String getAccountName() {
            return accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public final String getAccountPassword() {
            return accountPassword;
        }

        @Override
        public final Builder accountPassword(String accountPassword) {
            this.accountPassword = accountPassword;
            return this;
        }

        public final void setAccountPassword(String accountPassword) {
            this.accountPassword = accountPassword;
        }

        @Override
        public ServiceAccountCredentials build() {
            return new ServiceAccountCredentials(this);
        }
    }
}
