/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.DomainJoinInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the information needed for streaming instances to join a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DomainJoinInfo implements StructuredPojo, ToCopyableBuilder<DomainJoinInfo.Builder, DomainJoinInfo> {
    private final String directoryName;

    private final String organizationalUnitDistinguishedName;

    private DomainJoinInfo(BuilderImpl builder) {
        this.directoryName = builder.directoryName;
        this.organizationalUnitDistinguishedName = builder.organizationalUnitDistinguishedName;
    }

    /**
     * <p>
     * The fully qualified name of the directory (for example, corp.example.com).
     * </p>
     * 
     * @return The fully qualified name of the directory (for example, corp.example.com).
     */
    public String directoryName() {
        return directoryName;
    }

    /**
     * <p>
     * The distinguished name of the organizational unit for computer accounts.
     * </p>
     * 
     * @return The distinguished name of the organizational unit for computer accounts.
     */
    public String organizationalUnitDistinguishedName() {
        return organizationalUnitDistinguishedName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryName());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitDistinguishedName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainJoinInfo)) {
            return false;
        }
        DomainJoinInfo other = (DomainJoinInfo) obj;
        return Objects.equals(directoryName(), other.directoryName())
                && Objects.equals(organizationalUnitDistinguishedName(), other.organizationalUnitDistinguishedName());
    }

    @Override
    public String toString() {
        return ToString.builder("DomainJoinInfo").add("DirectoryName", directoryName())
                .add("OrganizationalUnitDistinguishedName", organizationalUnitDistinguishedName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryName":
            return Optional.of(clazz.cast(directoryName()));
        case "OrganizationalUnitDistinguishedName":
            return Optional.of(clazz.cast(organizationalUnitDistinguishedName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainJoinInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DomainJoinInfo> {
        /**
         * <p>
         * The fully qualified name of the directory (for example, corp.example.com).
         * </p>
         * 
         * @param directoryName
         *        The fully qualified name of the directory (for example, corp.example.com).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryName(String directoryName);

        /**
         * <p>
         * The distinguished name of the organizational unit for computer accounts.
         * </p>
         * 
         * @param organizationalUnitDistinguishedName
         *        The distinguished name of the organizational unit for computer accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitDistinguishedName(String organizationalUnitDistinguishedName);
    }

    static final class BuilderImpl implements Builder {
        private String directoryName;

        private String organizationalUnitDistinguishedName;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainJoinInfo model) {
            directoryName(model.directoryName);
            organizationalUnitDistinguishedName(model.organizationalUnitDistinguishedName);
        }

        public final String getDirectoryName() {
            return directoryName;
        }

        @Override
        public final Builder directoryName(String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public final void setDirectoryName(String directoryName) {
            this.directoryName = directoryName;
        }

        public final String getOrganizationalUnitDistinguishedName() {
            return organizationalUnitDistinguishedName;
        }

        @Override
        public final Builder organizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
            return this;
        }

        public final void setOrganizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
        }

        @Override
        public DomainJoinInfo build() {
            return new DomainJoinInfo(this);
        }
    }
}
