/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.DirectoryConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for the directory used to join domains.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DirectoryConfig implements StructuredPojo, ToCopyableBuilder<DirectoryConfig.Builder, DirectoryConfig> {
    private final String directoryName;

    private final List<String> organizationalUnitDistinguishedNames;

    private final ServiceAccountCredentials serviceAccountCredentials;

    private final Instant createdTime;

    private DirectoryConfig(BuilderImpl builder) {
        this.directoryName = builder.directoryName;
        this.organizationalUnitDistinguishedNames = builder.organizationalUnitDistinguishedNames;
        this.serviceAccountCredentials = builder.serviceAccountCredentials;
        this.createdTime = builder.createdTime;
    }

    /**
     * <p>
     * The fully qualified name of the directory (for example, corp.example.com).
     * </p>
     * 
     * @return The fully qualified name of the directory (for example, corp.example.com).
     */
    public String directoryName() {
        return directoryName;
    }

    /**
     * <p>
     * The distinguished names of the organizational units for computer accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The distinguished names of the organizational units for computer accounts.
     */
    public List<String> organizationalUnitDistinguishedNames() {
        return organizationalUnitDistinguishedNames;
    }

    /**
     * <p>
     * The credentials for the service account used by the streaming instance to connect to the directory.
     * </p>
     * 
     * @return The credentials for the service account used by the streaming instance to connect to the directory.
     */
    public ServiceAccountCredentials serviceAccountCredentials() {
        return serviceAccountCredentials;
    }

    /**
     * <p>
     * The time the directory configuration was created.
     * </p>
     * 
     * @return The time the directory configuration was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryName());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitDistinguishedNames());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectoryConfig)) {
            return false;
        }
        DirectoryConfig other = (DirectoryConfig) obj;
        return Objects.equals(directoryName(), other.directoryName())
                && Objects.equals(organizationalUnitDistinguishedNames(), other.organizationalUnitDistinguishedNames())
                && Objects.equals(serviceAccountCredentials(), other.serviceAccountCredentials())
                && Objects.equals(createdTime(), other.createdTime());
    }

    @Override
    public String toString() {
        return ToString.builder("DirectoryConfig").add("DirectoryName", directoryName())
                .add("OrganizationalUnitDistinguishedNames", organizationalUnitDistinguishedNames())
                .add("ServiceAccountCredentials", serviceAccountCredentials()).add("CreatedTime", createdTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryName":
            return Optional.of(clazz.cast(directoryName()));
        case "OrganizationalUnitDistinguishedNames":
            return Optional.of(clazz.cast(organizationalUnitDistinguishedNames()));
        case "ServiceAccountCredentials":
            return Optional.of(clazz.cast(serviceAccountCredentials()));
        case "CreatedTime":
            return Optional.of(clazz.cast(createdTime()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DirectoryConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DirectoryConfig> {
        /**
         * <p>
         * The fully qualified name of the directory (for example, corp.example.com).
         * </p>
         * 
         * @param directoryName
         *        The fully qualified name of the directory (for example, corp.example.com).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryName(String directoryName);

        /**
         * <p>
         * The distinguished names of the organizational units for computer accounts.
         * </p>
         * 
         * @param organizationalUnitDistinguishedNames
         *        The distinguished names of the organizational units for computer accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames);

        /**
         * <p>
         * The distinguished names of the organizational units for computer accounts.
         * </p>
         * 
         * @param organizationalUnitDistinguishedNames
         *        The distinguished names of the organizational units for computer accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitDistinguishedNames(String... organizationalUnitDistinguishedNames);

        /**
         * <p>
         * The credentials for the service account used by the streaming instance to connect to the directory.
         * </p>
         * 
         * @param serviceAccountCredentials
         *        The credentials for the service account used by the streaming instance to connect to the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountCredentials(ServiceAccountCredentials serviceAccountCredentials);

        /**
         * <p>
         * The credentials for the service account used by the streaming instance to connect to the directory.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceAccountCredentials.Builder} avoiding the
         * need to create one manually via {@link ServiceAccountCredentials#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceAccountCredentials.Builder#build()} is called immediately
         * and its result is passed to {@link #serviceAccountCredentials(ServiceAccountCredentials)}.
         * 
         * @param serviceAccountCredentials
         *        a consumer that will call methods on {@link ServiceAccountCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceAccountCredentials(ServiceAccountCredentials)
         */
        default Builder serviceAccountCredentials(Consumer<ServiceAccountCredentials.Builder> serviceAccountCredentials) {
            return serviceAccountCredentials(ServiceAccountCredentials.builder().apply(serviceAccountCredentials).build());
        }

        /**
         * <p>
         * The time the directory configuration was created.
         * </p>
         * 
         * @param createdTime
         *        The time the directory configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);
    }

    static final class BuilderImpl implements Builder {
        private String directoryName;

        private List<String> organizationalUnitDistinguishedNames;

        private ServiceAccountCredentials serviceAccountCredentials;

        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectoryConfig model) {
            directoryName(model.directoryName);
            organizationalUnitDistinguishedNames(model.organizationalUnitDistinguishedNames);
            serviceAccountCredentials(model.serviceAccountCredentials);
            createdTime(model.createdTime);
        }

        public final String getDirectoryName() {
            return directoryName;
        }

        @Override
        public final Builder directoryName(String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public final void setDirectoryName(String directoryName) {
            this.directoryName = directoryName;
        }

        public final Collection<String> getOrganizationalUnitDistinguishedNames() {
            return organizationalUnitDistinguishedNames;
        }

        @Override
        public final Builder organizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNamesListCopier
                    .copy(organizationalUnitDistinguishedNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitDistinguishedNames(String... organizationalUnitDistinguishedNames) {
            organizationalUnitDistinguishedNames(Arrays.asList(organizationalUnitDistinguishedNames));
            return this;
        }

        public final void setOrganizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNamesListCopier
                    .copy(organizationalUnitDistinguishedNames);
        }

        public final ServiceAccountCredentials.Builder getServiceAccountCredentials() {
            return serviceAccountCredentials != null ? serviceAccountCredentials.toBuilder() : null;
        }

        @Override
        public final Builder serviceAccountCredentials(ServiceAccountCredentials serviceAccountCredentials) {
            this.serviceAccountCredentials = serviceAccountCredentials;
            return this;
        }

        public final void setServiceAccountCredentials(ServiceAccountCredentials.BuilderImpl serviceAccountCredentials) {
            this.serviceAccountCredentials = serviceAccountCredentials != null ? serviceAccountCredentials.build() : null;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public DirectoryConfig build() {
            return new DirectoryConfig(this);
        }
    }
}
