/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDirectoryConfigsRequest extends AppStreamRequest implements
        ToCopyableBuilder<DescribeDirectoryConfigsRequest.Builder, DescribeDirectoryConfigsRequest> {
    private final List<String> directoryNames;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeDirectoryConfigsRequest(BuilderImpl builder) {
        super(builder);
        this.directoryNames = builder.directoryNames;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The directory names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The directory names.
     */
    public List<String> directoryNames() {
        return directoryNames;
    }

    /**
     * <p>
     * The maximum size of each page of results.
     * </p>
     * 
     * @return The maximum size of each page of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If this value is null, it
     * retrieves the first page.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If this value is
     *         null, it retrieves the first page.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryNames());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectoryConfigsRequest)) {
            return false;
        }
        DescribeDirectoryConfigsRequest other = (DescribeDirectoryConfigsRequest) obj;
        return Objects.equals(directoryNames(), other.directoryNames()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeDirectoryConfigsRequest").add("DirectoryNames", directoryNames())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryNames":
            return Optional.of(clazz.cast(directoryNames()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AppStreamRequest.Builder, CopyableBuilder<Builder, DescribeDirectoryConfigsRequest> {
        /**
         * <p>
         * The directory names.
         * </p>
         * 
         * @param directoryNames
         *        The directory names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryNames(Collection<String> directoryNames);

        /**
         * <p>
         * The directory names.
         * </p>
         * 
         * @param directoryNames
         *        The directory names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryNames(String... directoryNames);

        /**
         * <p>
         * The maximum size of each page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum size of each page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If this value is null,
         * it retrieves the first page.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If this value is
         *        null, it retrieves the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private List<String> directoryNames;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectoryConfigsRequest model) {
            super(model);
            directoryNames(model.directoryNames);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getDirectoryNames() {
            return directoryNames;
        }

        @Override
        public final Builder directoryNames(Collection<String> directoryNames) {
            this.directoryNames = DirectoryNameListCopier.copy(directoryNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryNames(String... directoryNames) {
            directoryNames(Arrays.asList(directoryNames));
            return this;
        }

        public final void setDirectoryNames(Collection<String> directoryNames) {
            this.directoryNames = DirectoryNameListCopier.copy(directoryNames);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeDirectoryConfigsRequest build() {
            return new DescribeDirectoryConfigsRequest(this);
        }
    }
}
