/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apprunner.AppRunnerClient;
import software.amazon.awssdk.services.apprunner.internal.UserAgentUtils;
import software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsRequest;
import software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsResponse;

public class ListObservabilityConfigurationsIterable
implements SdkIterable<ListObservabilityConfigurationsResponse> {
    private final AppRunnerClient client;
    private final ListObservabilityConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListObservabilityConfigurationsIterable(AppRunnerClient client, ListObservabilityConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListObservabilityConfigurationsResponseFetcher();
    }

    public Iterator<ListObservabilityConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListObservabilityConfigurationsResponseFetcher
    implements SyncPageFetcher<ListObservabilityConfigurationsResponse> {
        private ListObservabilityConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListObservabilityConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListObservabilityConfigurationsResponse nextPage(ListObservabilityConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListObservabilityConfigurationsIterable.this.client.listObservabilityConfigurations(ListObservabilityConfigurationsIterable.this.firstRequest);
            }
            return ListObservabilityConfigurationsIterable.this.client.listObservabilityConfigurations((ListObservabilityConfigurationsRequest)((Object)ListObservabilityConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

