/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apprunner.AppRunnerAsyncClient;
import software.amazon.awssdk.services.apprunner.model.ListVpcConnectorsRequest;
import software.amazon.awssdk.services.apprunner.model.ListVpcConnectorsResponse;

public class ListVpcConnectorsPublisher
implements SdkPublisher<ListVpcConnectorsResponse> {
    private final AppRunnerAsyncClient client;
    private final ListVpcConnectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVpcConnectorsPublisher(AppRunnerAsyncClient client, ListVpcConnectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVpcConnectorsPublisher(AppRunnerAsyncClient client, ListVpcConnectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVpcConnectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVpcConnectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListVpcConnectorsResponseFetcher
    implements AsyncPageFetcher<ListVpcConnectorsResponse> {
        private ListVpcConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListVpcConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVpcConnectorsResponse> nextPage(ListVpcConnectorsResponse previousPage) {
            if (previousPage == null) {
                return ListVpcConnectorsPublisher.this.client.listVpcConnectors(ListVpcConnectorsPublisher.this.firstRequest);
            }
            return ListVpcConnectorsPublisher.this.client.listVpcConnectors((ListVpcConnectorsRequest)((Object)ListVpcConnectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

