/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apprunner.AppRunnerAsyncClient;
import software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsRequest;
import software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsResponse;

public class ListAutoScalingConfigurationsPublisher
implements SdkPublisher<ListAutoScalingConfigurationsResponse> {
    private final AppRunnerAsyncClient client;
    private final ListAutoScalingConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAutoScalingConfigurationsPublisher(AppRunnerAsyncClient client, ListAutoScalingConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAutoScalingConfigurationsPublisher(AppRunnerAsyncClient client, ListAutoScalingConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAutoScalingConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAutoScalingConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAutoScalingConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListAutoScalingConfigurationsResponse> {
        private ListAutoScalingConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAutoScalingConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAutoScalingConfigurationsResponse> nextPage(ListAutoScalingConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListAutoScalingConfigurationsPublisher.this.client.listAutoScalingConfigurations(ListAutoScalingConfigurationsPublisher.this.firstRequest);
            }
            return ListAutoScalingConfigurationsPublisher.this.client.listAutoScalingConfigurations((ListAutoScalingConfigurationsRequest)((Object)ListAutoScalingConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

