/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apprunner.AppRunnerClient;
import software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsRequest;
import software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsResponse;

public class ListAutoScalingConfigurationsIterable
implements SdkIterable<ListAutoScalingConfigurationsResponse> {
    private final AppRunnerClient client;
    private final ListAutoScalingConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAutoScalingConfigurationsIterable(AppRunnerClient client, ListAutoScalingConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAutoScalingConfigurationsResponseFetcher();
    }

    public Iterator<ListAutoScalingConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAutoScalingConfigurationsResponseFetcher
    implements SyncPageFetcher<ListAutoScalingConfigurationsResponse> {
        private ListAutoScalingConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAutoScalingConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAutoScalingConfigurationsResponse nextPage(ListAutoScalingConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListAutoScalingConfigurationsIterable.this.client.listAutoScalingConfigurations(ListAutoScalingConfigurationsIterable.this.firstRequest);
            }
            return ListAutoScalingConfigurationsIterable.this.client.listAutoScalingConfigurations((ListAutoScalingConfigurationsRequest)((Object)ListAutoScalingConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

