/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes resources needed to authenticate access to some source repositories. The specific resource depends on the
 * repository provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticationConfiguration.Builder, AuthenticationConfiguration> {
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionArn").getter(getter(AuthenticationConfiguration::connectionArn))
            .setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()).build();

    private static final SdkField<String> ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessRoleArn").getter(getter(AuthenticationConfiguration::accessRoleArn))
            .setter(setter(Builder::accessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ARN_FIELD,
            ACCESS_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectionArn;

    private final String accessRoleArn;

    private AuthenticationConfiguration(BuilderImpl builder) {
        this.connectionArn = builder.connectionArn;
        this.accessRoleArn = builder.accessRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the App Runner connection that enables the App Runner service to connect to a
     * source repository. It's required for GitHub code repositories.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the App Runner connection that enables the App Runner service to
     *         connect to a source repository. It's required for GitHub code repositories.
     */
    public final String connectionArn() {
        return connectionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that grants the App Runner service access to a source repository.
     * It's required for ECR image repositories (but not for ECR Public repositories).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that grants the App Runner service access to a source
     *         repository. It's required for ECR image repositories (but not for ECR Public repositories).
     */
    public final String accessRoleArn() {
        return accessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(accessRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationConfiguration)) {
            return false;
        }
        AuthenticationConfiguration other = (AuthenticationConfiguration) obj;
        return Objects.equals(connectionArn(), other.connectionArn()) && Objects.equals(accessRoleArn(), other.accessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthenticationConfiguration").add("ConnectionArn", connectionArn())
                .add("AccessRoleArn", accessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        case "AccessRoleArn":
            return Optional.ofNullable(clazz.cast(accessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationConfiguration, T> g) {
        return obj -> g.apply((AuthenticationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticationConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the App Runner connection that enables the App Runner service to connect to
         * a source repository. It's required for GitHub code repositories.
         * </p>
         * 
         * @param connectionArn
         *        The Amazon Resource Name (ARN) of the App Runner connection that enables the App Runner service to
         *        connect to a source repository. It's required for GitHub code repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that grants the App Runner service access to a source
         * repository. It's required for ECR image repositories (but not for ECR Public repositories).
         * </p>
         * 
         * @param accessRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that grants the App Runner service access to a source
         *        repository. It's required for ECR image repositories (but not for ECR Public repositories).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessRoleArn(String accessRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String connectionArn;

        private String accessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationConfiguration model) {
            connectionArn(model.connectionArn);
            accessRoleArn(model.accessRoleArn);
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        public final String getAccessRoleArn() {
            return accessRoleArn;
        }

        @Override
        public final Builder accessRoleArn(String accessRoleArn) {
            this.accessRoleArn = accessRoleArn;
            return this;
        }

        public final void setAccessRoleArn(String accessRoleArn) {
            this.accessRoleArn = accessRoleArn;
        }

        @Override
        public AuthenticationConfiguration build() {
            return new AuthenticationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
