/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOperationsResponse extends AppRunnerResponse implements
        ToCopyableBuilder<ListOperationsResponse.Builder, ListOperationsResponse> {
    private static final SdkField<List<OperationSummary>> OPERATION_SUMMARY_LIST_FIELD = SdkField
            .<List<OperationSummary>> builder(MarshallingType.LIST)
            .memberName("OperationSummaryList")
            .getter(getter(ListOperationsResponse::operationSummaryList))
            .setter(setter(Builder::operationSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OperationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(OperationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListOperationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_SUMMARY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<OperationSummary> operationSummaryList;

    private final String nextToken;

    private ListOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.operationSummaryList = builder.operationSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the OperationSummaryList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasOperationSummaryList() {
        return operationSummaryList != null && !(operationSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of operation summary information records. In a paginated request, the request returns up to
     * <code>MaxResults</code> records for each call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOperationSummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of operation summary information records. In a paginated request, the request returns up to
     *         <code>MaxResults</code> records for each call.
     */
    public final List<OperationSummary> operationSummaryList() {
        return operationSummaryList;
    }

    /**
     * <p>
     * The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated
     * request.
     * </p>
     * 
     * @return The token that you can pass in a subsequent request to get the next result page. It's returned in a
     *         paginated request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOperationSummaryList() ? operationSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsResponse)) {
            return false;
        }
        ListOperationsResponse other = (ListOperationsResponse) obj;
        return hasOperationSummaryList() == other.hasOperationSummaryList()
                && Objects.equals(operationSummaryList(), other.operationSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOperationsResponse")
                .add("OperationSummaryList", hasOperationSummaryList() ? operationSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OperationSummaryList":
            return Optional.ofNullable(clazz.cast(operationSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOperationsResponse, T> g) {
        return obj -> g.apply((ListOperationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppRunnerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListOperationsResponse> {
        /**
         * <p>
         * A list of operation summary information records. In a paginated request, the request returns up to
         * <code>MaxResults</code> records for each call.
         * </p>
         * 
         * @param operationSummaryList
         *        A list of operation summary information records. In a paginated request, the request returns up to
         *        <code>MaxResults</code> records for each call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationSummaryList(Collection<OperationSummary> operationSummaryList);

        /**
         * <p>
         * A list of operation summary information records. In a paginated request, the request returns up to
         * <code>MaxResults</code> records for each call.
         * </p>
         * 
         * @param operationSummaryList
         *        A list of operation summary information records. In a paginated request, the request returns up to
         *        <code>MaxResults</code> records for each call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationSummaryList(OperationSummary... operationSummaryList);

        /**
         * <p>
         * A list of operation summary information records. In a paginated request, the request returns up to
         * <code>MaxResults</code> records for each call.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OperationSummary>.Builder} avoiding the
         * need to create one manually via {@link List<OperationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OperationSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #operationSummaryList(List<OperationSummary>)}.
         * 
         * @param operationSummaryList
         *        a consumer that will call methods on {@link List<OperationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operationSummaryList(List<OperationSummary>)
         */
        Builder operationSummaryList(Consumer<OperationSummary.Builder>... operationSummaryList);

        /**
         * <p>
         * The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated
         * request.
         * </p>
         * 
         * @param nextToken
         *        The token that you can pass in a subsequent request to get the next result page. It's returned in a
         *        paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppRunnerResponse.BuilderImpl implements Builder {
        private List<OperationSummary> operationSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOperationsResponse model) {
            super(model);
            operationSummaryList(model.operationSummaryList);
            nextToken(model.nextToken);
        }

        public final List<OperationSummary.Builder> getOperationSummaryList() {
            List<OperationSummary.Builder> result = OperationSummaryListCopier.copyToBuilder(this.operationSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder operationSummaryList(Collection<OperationSummary> operationSummaryList) {
            this.operationSummaryList = OperationSummaryListCopier.copy(operationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationSummaryList(OperationSummary... operationSummaryList) {
            operationSummaryList(Arrays.asList(operationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationSummaryList(Consumer<OperationSummary.Builder>... operationSummaryList) {
            operationSummaryList(Stream.of(operationSummaryList).map(c -> OperationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOperationSummaryList(Collection<OperationSummary.BuilderImpl> operationSummaryList) {
            this.operationSummaryList = OperationSummaryListCopier.copyFromBuilder(operationSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOperationsResponse build() {
            return new ListOperationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
