/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a source code repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeRepository implements SdkPojo, Serializable, ToCopyableBuilder<CodeRepository.Builder, CodeRepository> {
    private static final SdkField<String> REPOSITORY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryUrl").getter(getter(CodeRepository::repositoryUrl)).setter(setter(Builder::repositoryUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryUrl").build()).build();

    private static final SdkField<SourceCodeVersion> SOURCE_CODE_VERSION_FIELD = SdkField
            .<SourceCodeVersion> builder(MarshallingType.SDK_POJO).memberName("SourceCodeVersion")
            .getter(getter(CodeRepository::sourceCodeVersion)).setter(setter(Builder::sourceCodeVersion))
            .constructor(SourceCodeVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCodeVersion").build()).build();

    private static final SdkField<CodeConfiguration> CODE_CONFIGURATION_FIELD = SdkField
            .<CodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("CodeConfiguration")
            .getter(getter(CodeRepository::codeConfiguration)).setter(setter(Builder::codeConfiguration))
            .constructor(CodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_URL_FIELD,
            SOURCE_CODE_VERSION_FIELD, CODE_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repositoryUrl;

    private final SourceCodeVersion sourceCodeVersion;

    private final CodeConfiguration codeConfiguration;

    private CodeRepository(BuilderImpl builder) {
        this.repositoryUrl = builder.repositoryUrl;
        this.sourceCodeVersion = builder.sourceCodeVersion;
        this.codeConfiguration = builder.codeConfiguration;
    }

    /**
     * <p>
     * The location of the repository that contains the source code.
     * </p>
     * 
     * @return The location of the repository that contains the source code.
     */
    public final String repositoryUrl() {
        return repositoryUrl;
    }

    /**
     * <p>
     * The version that should be used within the source code repository.
     * </p>
     * 
     * @return The version that should be used within the source code repository.
     */
    public final SourceCodeVersion sourceCodeVersion() {
        return sourceCodeVersion;
    }

    /**
     * <p>
     * Configuration for building and running the service from a source code repository.
     * </p>
     * 
     * @return Configuration for building and running the service from a source code repository.
     */
    public final CodeConfiguration codeConfiguration() {
        return codeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCodeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(codeConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeRepository)) {
            return false;
        }
        CodeRepository other = (CodeRepository) obj;
        return Objects.equals(repositoryUrl(), other.repositoryUrl())
                && Objects.equals(sourceCodeVersion(), other.sourceCodeVersion())
                && Objects.equals(codeConfiguration(), other.codeConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeRepository").add("RepositoryUrl", repositoryUrl())
                .add("SourceCodeVersion", sourceCodeVersion()).add("CodeConfiguration", codeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RepositoryUrl":
            return Optional.ofNullable(clazz.cast(repositoryUrl()));
        case "SourceCodeVersion":
            return Optional.ofNullable(clazz.cast(sourceCodeVersion()));
        case "CodeConfiguration":
            return Optional.ofNullable(clazz.cast(codeConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeRepository, T> g) {
        return obj -> g.apply((CodeRepository) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeRepository> {
        /**
         * <p>
         * The location of the repository that contains the source code.
         * </p>
         * 
         * @param repositoryUrl
         *        The location of the repository that contains the source code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryUrl(String repositoryUrl);

        /**
         * <p>
         * The version that should be used within the source code repository.
         * </p>
         * 
         * @param sourceCodeVersion
         *        The version that should be used within the source code repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeVersion(SourceCodeVersion sourceCodeVersion);

        /**
         * <p>
         * The version that should be used within the source code repository.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceCodeVersion.Builder} avoiding the need to
         * create one manually via {@link SourceCodeVersion#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceCodeVersion.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceCodeVersion(SourceCodeVersion)}.
         * 
         * @param sourceCodeVersion
         *        a consumer that will call methods on {@link SourceCodeVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceCodeVersion(SourceCodeVersion)
         */
        default Builder sourceCodeVersion(Consumer<SourceCodeVersion.Builder> sourceCodeVersion) {
            return sourceCodeVersion(SourceCodeVersion.builder().applyMutation(sourceCodeVersion).build());
        }

        /**
         * <p>
         * Configuration for building and running the service from a source code repository.
         * </p>
         * 
         * @param codeConfiguration
         *        Configuration for building and running the service from a source code repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeConfiguration(CodeConfiguration codeConfiguration);

        /**
         * <p>
         * Configuration for building and running the service from a source code repository.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeConfiguration.Builder} avoiding the need to
         * create one manually via {@link CodeConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #codeConfiguration(CodeConfiguration)}.
         * 
         * @param codeConfiguration
         *        a consumer that will call methods on {@link CodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeConfiguration(CodeConfiguration)
         */
        default Builder codeConfiguration(Consumer<CodeConfiguration.Builder> codeConfiguration) {
            return codeConfiguration(CodeConfiguration.builder().applyMutation(codeConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String repositoryUrl;

        private SourceCodeVersion sourceCodeVersion;

        private CodeConfiguration codeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeRepository model) {
            repositoryUrl(model.repositoryUrl);
            sourceCodeVersion(model.sourceCodeVersion);
            codeConfiguration(model.codeConfiguration);
        }

        public final String getRepositoryUrl() {
            return repositoryUrl;
        }

        @Override
        public final Builder repositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            return this;
        }

        public final void setRepositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
        }

        public final SourceCodeVersion.Builder getSourceCodeVersion() {
            return sourceCodeVersion != null ? sourceCodeVersion.toBuilder() : null;
        }

        @Override
        public final Builder sourceCodeVersion(SourceCodeVersion sourceCodeVersion) {
            this.sourceCodeVersion = sourceCodeVersion;
            return this;
        }

        public final void setSourceCodeVersion(SourceCodeVersion.BuilderImpl sourceCodeVersion) {
            this.sourceCodeVersion = sourceCodeVersion != null ? sourceCodeVersion.build() : null;
        }

        public final CodeConfiguration.Builder getCodeConfiguration() {
            return codeConfiguration != null ? codeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder codeConfiguration(CodeConfiguration codeConfiguration) {
            this.codeConfiguration = codeConfiguration;
            return this;
        }

        public final void setCodeConfiguration(CodeConfiguration.BuilderImpl codeConfiguration) {
            this.codeConfiguration = codeConfiguration != null ? codeConfiguration.build() : null;
        }

        @Override
        public CodeRepository build() {
            return new CodeRepository(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
