/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationsignals.ApplicationSignalsClient;
import software.amazon.awssdk.services.applicationsignals.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceDependentsRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceDependentsResponse;
import software.amazon.awssdk.services.applicationsignals.model.ServiceDependent;

public class ListServiceDependentsIterable
implements SdkIterable<ListServiceDependentsResponse> {
    private final ApplicationSignalsClient client;
    private final ListServiceDependentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceDependentsIterable(ApplicationSignalsClient client, ListServiceDependentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServiceDependentsResponseFetcher();
    }

    public Iterator<ListServiceDependentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceDependent> serviceDependents() {
        Function<ListServiceDependentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceDependents() != null) {
                return response.serviceDependents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceDependentsResponseFetcher
    implements SyncPageFetcher<ListServiceDependentsResponse> {
        private ListServiceDependentsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceDependentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceDependentsResponse nextPage(ListServiceDependentsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceDependentsIterable.this.client.listServiceDependents(ListServiceDependentsIterable.this.firstRequest);
            }
            return ListServiceDependentsIterable.this.client.listServiceDependents((ListServiceDependentsRequest)((Object)ListServiceDependentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

