/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationsignals.model.EvaluationType;
import software.amazon.awssdk.services.applicationsignals.model.Goal;
import software.amazon.awssdk.services.applicationsignals.model.RequestBasedServiceLevelIndicator;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelIndicator;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveBudgetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceLevelObjectiveBudgetReport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceLevelObjectiveBudgetReport> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::arn)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::name)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> EVALUATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationType").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::evaluationTypeAsString)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::evaluationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationType").build()}).build();
    private static final SdkField<String> BUDGET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BudgetStatus").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::budgetStatusAsString)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::budgetStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetStatus").build()}).build();
    private static final SdkField<Double> ATTAINMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Attainment").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::attainment)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::attainment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attainment").build()}).build();
    private static final SdkField<Integer> TOTAL_BUDGET_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalBudgetSeconds").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::totalBudgetSeconds)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::totalBudgetSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalBudgetSeconds").build()}).build();
    private static final SdkField<Integer> BUDGET_SECONDS_REMAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BudgetSecondsRemaining").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::budgetSecondsRemaining)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::budgetSecondsRemaining)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetSecondsRemaining").build()}).build();
    private static final SdkField<Integer> TOTAL_BUDGET_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalBudgetRequests").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::totalBudgetRequests)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::totalBudgetRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalBudgetRequests").build()}).build();
    private static final SdkField<Integer> BUDGET_REQUESTS_REMAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BudgetRequestsRemaining").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::budgetRequestsRemaining)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::budgetRequestsRemaining)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetRequestsRemaining").build()}).build();
    private static final SdkField<ServiceLevelIndicator> SLI_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sli").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::sli)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::sli)).constructor(ServiceLevelIndicator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sli").build()}).build();
    private static final SdkField<RequestBasedServiceLevelIndicator> REQUEST_BASED_SLI_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequestBasedSli").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::requestBasedSli)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::requestBasedSli)).constructor(RequestBasedServiceLevelIndicator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestBasedSli").build()}).build();
    private static final SdkField<Goal> GOAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Goal").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::goal)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::goal)).constructor(Goal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Goal").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, EVALUATION_TYPE_FIELD, BUDGET_STATUS_FIELD, ATTAINMENT_FIELD, TOTAL_BUDGET_SECONDS_FIELD, BUDGET_SECONDS_REMAINING_FIELD, TOTAL_BUDGET_REQUESTS_FIELD, BUDGET_REQUESTS_REMAINING_FIELD, SLI_FIELD, REQUEST_BASED_SLI_FIELD, GOAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("EvaluationType", EVALUATION_TYPE_FIELD);
            this.put("BudgetStatus", BUDGET_STATUS_FIELD);
            this.put("Attainment", ATTAINMENT_FIELD);
            this.put("TotalBudgetSeconds", TOTAL_BUDGET_SECONDS_FIELD);
            this.put("BudgetSecondsRemaining", BUDGET_SECONDS_REMAINING_FIELD);
            this.put("TotalBudgetRequests", TOTAL_BUDGET_REQUESTS_FIELD);
            this.put("BudgetRequestsRemaining", BUDGET_REQUESTS_REMAINING_FIELD);
            this.put("Sli", SLI_FIELD);
            this.put("RequestBasedSli", REQUEST_BASED_SLI_FIELD);
            this.put("Goal", GOAL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String evaluationType;
    private final String budgetStatus;
    private final Double attainment;
    private final Integer totalBudgetSeconds;
    private final Integer budgetSecondsRemaining;
    private final Integer totalBudgetRequests;
    private final Integer budgetRequestsRemaining;
    private final ServiceLevelIndicator sli;
    private final RequestBasedServiceLevelIndicator requestBasedSli;
    private final Goal goal;

    private ServiceLevelObjectiveBudgetReport(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.evaluationType = builder.evaluationType;
        this.budgetStatus = builder.budgetStatus;
        this.attainment = builder.attainment;
        this.totalBudgetSeconds = builder.totalBudgetSeconds;
        this.budgetSecondsRemaining = builder.budgetSecondsRemaining;
        this.totalBudgetRequests = builder.totalBudgetRequests;
        this.budgetRequestsRemaining = builder.budgetRequestsRemaining;
        this.sli = builder.sli;
        this.requestBasedSli = builder.requestBasedSli;
        this.goal = builder.goal;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final EvaluationType evaluationType() {
        return EvaluationType.fromValue(this.evaluationType);
    }

    public final String evaluationTypeAsString() {
        return this.evaluationType;
    }

    public final ServiceLevelObjectiveBudgetStatus budgetStatus() {
        return ServiceLevelObjectiveBudgetStatus.fromValue(this.budgetStatus);
    }

    public final String budgetStatusAsString() {
        return this.budgetStatus;
    }

    public final Double attainment() {
        return this.attainment;
    }

    public final Integer totalBudgetSeconds() {
        return this.totalBudgetSeconds;
    }

    public final Integer budgetSecondsRemaining() {
        return this.budgetSecondsRemaining;
    }

    public final Integer totalBudgetRequests() {
        return this.totalBudgetRequests;
    }

    public final Integer budgetRequestsRemaining() {
        return this.budgetRequestsRemaining;
    }

    public final ServiceLevelIndicator sli() {
        return this.sli;
    }

    public final RequestBasedServiceLevelIndicator requestBasedSli() {
        return this.requestBasedSli;
    }

    public final Goal goal() {
        return this.goal;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attainment());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalBudgetSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetSecondsRemaining());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalBudgetRequests());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetRequestsRemaining());
        hashCode = 31 * hashCode + Objects.hashCode(this.sli());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestBasedSli());
        hashCode = 31 * hashCode + Objects.hashCode(this.goal());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLevelObjectiveBudgetReport)) {
            return false;
        }
        ServiceLevelObjectiveBudgetReport other = (ServiceLevelObjectiveBudgetReport)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.evaluationTypeAsString(), other.evaluationTypeAsString()) && Objects.equals(this.budgetStatusAsString(), other.budgetStatusAsString()) && Objects.equals(this.attainment(), other.attainment()) && Objects.equals(this.totalBudgetSeconds(), other.totalBudgetSeconds()) && Objects.equals(this.budgetSecondsRemaining(), other.budgetSecondsRemaining()) && Objects.equals(this.totalBudgetRequests(), other.totalBudgetRequests()) && Objects.equals(this.budgetRequestsRemaining(), other.budgetRequestsRemaining()) && Objects.equals(this.sli(), other.sli()) && Objects.equals(this.requestBasedSli(), other.requestBasedSli()) && Objects.equals(this.goal(), other.goal());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceLevelObjectiveBudgetReport").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("EvaluationType", (Object)this.evaluationTypeAsString()).add("BudgetStatus", (Object)this.budgetStatusAsString()).add("Attainment", (Object)this.attainment()).add("TotalBudgetSeconds", (Object)this.totalBudgetSeconds()).add("BudgetSecondsRemaining", (Object)this.budgetSecondsRemaining()).add("TotalBudgetRequests", (Object)this.totalBudgetRequests()).add("BudgetRequestsRemaining", (Object)this.budgetRequestsRemaining()).add("Sli", (Object)this.sli()).add("RequestBasedSli", (Object)this.requestBasedSli()).add("Goal", (Object)this.goal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "EvaluationType": {
                return Optional.ofNullable(clazz.cast(this.evaluationTypeAsString()));
            }
            case "BudgetStatus": {
                return Optional.ofNullable(clazz.cast(this.budgetStatusAsString()));
            }
            case "Attainment": {
                return Optional.ofNullable(clazz.cast(this.attainment()));
            }
            case "TotalBudgetSeconds": {
                return Optional.ofNullable(clazz.cast(this.totalBudgetSeconds()));
            }
            case "BudgetSecondsRemaining": {
                return Optional.ofNullable(clazz.cast(this.budgetSecondsRemaining()));
            }
            case "TotalBudgetRequests": {
                return Optional.ofNullable(clazz.cast(this.totalBudgetRequests()));
            }
            case "BudgetRequestsRemaining": {
                return Optional.ofNullable(clazz.cast(this.budgetRequestsRemaining()));
            }
            case "Sli": {
                return Optional.ofNullable(clazz.cast(this.sli()));
            }
            case "RequestBasedSli": {
                return Optional.ofNullable(clazz.cast(this.requestBasedSli()));
            }
            case "Goal": {
                return Optional.ofNullable(clazz.cast(this.goal()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ServiceLevelObjectiveBudgetReport, T> g) {
        return obj -> g.apply((ServiceLevelObjectiveBudgetReport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String evaluationType;
        private String budgetStatus;
        private Double attainment;
        private Integer totalBudgetSeconds;
        private Integer budgetSecondsRemaining;
        private Integer totalBudgetRequests;
        private Integer budgetRequestsRemaining;
        private ServiceLevelIndicator sli;
        private RequestBasedServiceLevelIndicator requestBasedSli;
        private Goal goal;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLevelObjectiveBudgetReport model) {
            this.arn(model.arn);
            this.name(model.name);
            this.evaluationType(model.evaluationType);
            this.budgetStatus(model.budgetStatus);
            this.attainment(model.attainment);
            this.totalBudgetSeconds(model.totalBudgetSeconds);
            this.budgetSecondsRemaining(model.budgetSecondsRemaining);
            this.totalBudgetRequests(model.totalBudgetRequests);
            this.budgetRequestsRemaining(model.budgetRequestsRemaining);
            this.sli(model.sli);
            this.requestBasedSli(model.requestBasedSli);
            this.goal(model.goal);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEvaluationType() {
            return this.evaluationType;
        }

        public final void setEvaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
        }

        @Override
        public final Builder evaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
            return this;
        }

        @Override
        public final Builder evaluationType(EvaluationType evaluationType) {
            this.evaluationType(evaluationType == null ? null : evaluationType.toString());
            return this;
        }

        public final String getBudgetStatus() {
            return this.budgetStatus;
        }

        public final void setBudgetStatus(String budgetStatus) {
            this.budgetStatus = budgetStatus;
        }

        @Override
        public final Builder budgetStatus(String budgetStatus) {
            this.budgetStatus = budgetStatus;
            return this;
        }

        @Override
        public final Builder budgetStatus(ServiceLevelObjectiveBudgetStatus budgetStatus) {
            this.budgetStatus(budgetStatus == null ? null : budgetStatus.toString());
            return this;
        }

        public final Double getAttainment() {
            return this.attainment;
        }

        public final void setAttainment(Double attainment) {
            this.attainment = attainment;
        }

        @Override
        public final Builder attainment(Double attainment) {
            this.attainment = attainment;
            return this;
        }

        public final Integer getTotalBudgetSeconds() {
            return this.totalBudgetSeconds;
        }

        public final void setTotalBudgetSeconds(Integer totalBudgetSeconds) {
            this.totalBudgetSeconds = totalBudgetSeconds;
        }

        @Override
        public final Builder totalBudgetSeconds(Integer totalBudgetSeconds) {
            this.totalBudgetSeconds = totalBudgetSeconds;
            return this;
        }

        public final Integer getBudgetSecondsRemaining() {
            return this.budgetSecondsRemaining;
        }

        public final void setBudgetSecondsRemaining(Integer budgetSecondsRemaining) {
            this.budgetSecondsRemaining = budgetSecondsRemaining;
        }

        @Override
        public final Builder budgetSecondsRemaining(Integer budgetSecondsRemaining) {
            this.budgetSecondsRemaining = budgetSecondsRemaining;
            return this;
        }

        public final Integer getTotalBudgetRequests() {
            return this.totalBudgetRequests;
        }

        public final void setTotalBudgetRequests(Integer totalBudgetRequests) {
            this.totalBudgetRequests = totalBudgetRequests;
        }

        @Override
        public final Builder totalBudgetRequests(Integer totalBudgetRequests) {
            this.totalBudgetRequests = totalBudgetRequests;
            return this;
        }

        public final Integer getBudgetRequestsRemaining() {
            return this.budgetRequestsRemaining;
        }

        public final void setBudgetRequestsRemaining(Integer budgetRequestsRemaining) {
            this.budgetRequestsRemaining = budgetRequestsRemaining;
        }

        @Override
        public final Builder budgetRequestsRemaining(Integer budgetRequestsRemaining) {
            this.budgetRequestsRemaining = budgetRequestsRemaining;
            return this;
        }

        public final ServiceLevelIndicator.Builder getSli() {
            return this.sli != null ? this.sli.toBuilder() : null;
        }

        public final void setSli(ServiceLevelIndicator.BuilderImpl sli) {
            this.sli = sli != null ? sli.build() : null;
        }

        @Override
        public final Builder sli(ServiceLevelIndicator sli) {
            this.sli = sli;
            return this;
        }

        public final RequestBasedServiceLevelIndicator.Builder getRequestBasedSli() {
            return this.requestBasedSli != null ? this.requestBasedSli.toBuilder() : null;
        }

        public final void setRequestBasedSli(RequestBasedServiceLevelIndicator.BuilderImpl requestBasedSli) {
            this.requestBasedSli = requestBasedSli != null ? requestBasedSli.build() : null;
        }

        @Override
        public final Builder requestBasedSli(RequestBasedServiceLevelIndicator requestBasedSli) {
            this.requestBasedSli = requestBasedSli;
            return this;
        }

        public final Goal.Builder getGoal() {
            return this.goal != null ? this.goal.toBuilder() : null;
        }

        public final void setGoal(Goal.BuilderImpl goal) {
            this.goal = goal != null ? goal.build() : null;
        }

        @Override
        public final Builder goal(Goal goal) {
            this.goal = goal;
            return this;
        }

        public ServiceLevelObjectiveBudgetReport build() {
            return new ServiceLevelObjectiveBudgetReport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceLevelObjectiveBudgetReport> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder evaluationType(String var1);

        public Builder evaluationType(EvaluationType var1);

        public Builder budgetStatus(String var1);

        public Builder budgetStatus(ServiceLevelObjectiveBudgetStatus var1);

        public Builder attainment(Double var1);

        public Builder totalBudgetSeconds(Integer var1);

        public Builder budgetSecondsRemaining(Integer var1);

        public Builder totalBudgetRequests(Integer var1);

        public Builder budgetRequestsRemaining(Integer var1);

        public Builder sli(ServiceLevelIndicator var1);

        default public Builder sli(Consumer<ServiceLevelIndicator.Builder> sli) {
            return this.sli((ServiceLevelIndicator)((ServiceLevelIndicator.Builder)ServiceLevelIndicator.builder().applyMutation(sli)).build());
        }

        public Builder requestBasedSli(RequestBasedServiceLevelIndicator var1);

        default public Builder requestBasedSli(Consumer<RequestBasedServiceLevelIndicator.Builder> requestBasedSli) {
            return this.requestBasedSli((RequestBasedServiceLevelIndicator)((RequestBasedServiceLevelIndicator.Builder)RequestBasedServiceLevelIndicator.builder().applyMutation(requestBasedSli)).build());
        }

        public Builder goal(Goal var1);

        default public Builder goal(Consumer<Goal.Builder> goal) {
            return this.goal((Goal)((Goal.Builder)Goal.builder().applyMutation(goal)).build());
        }
    }
}

