/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationinsights.ApplicationInsightsClient;
import software.amazon.awssdk.services.applicationinsights.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationinsights.model.ListApplicationsRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListApplicationsResponse;

public class ListApplicationsIterable
implements SdkIterable<ListApplicationsResponse> {
    private final ApplicationInsightsClient client;
    private final ListApplicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationsIterable(ApplicationInsightsClient client, ListApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationsResponseFetcher();
    }

    public Iterator<ListApplicationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListApplicationsResponseFetcher
    implements SyncPageFetcher<ListApplicationsResponse> {
        private ListApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApplicationsResponse nextPage(ListApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationsIterable.this.client.listApplications(ListApplicationsIterable.this.firstRequest);
            }
            return ListApplicationsIterable.this.client.listApplications((ListApplicationsRequest)((Object)ListApplicationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

