/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LogFilter {
    ERROR("ERROR"),
    WARN("WARN"),
    INFO("INFO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LogFilter> VALUE_MAP;
    private final String value;

    private LogFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LogFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LogFilter> knownValues() {
        EnumSet<LogFilter> knownValues = EnumSet.allOf(LogFilter.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LogFilter.class, LogFilter::toString);
    }
}

